/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.factories;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexFactory;
import com.hp.hpl.jena.tdb.index.IndexRangeFactory;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;

public class IndexFactoryBPlusTree
implements IndexFactory,
IndexRangeFactory {
    private final int blockSize;

    public IndexFactoryBPlusTree(int blockSize) {
        this.blockSize = blockSize;
    }

    @Override
    public Index createIndex(Location location, String name, RecordFactory factory) {
        return this.createRangeIndex(location, name, factory);
    }

    @Override
    public RangeIndex createRangeIndex(Location location, String name, RecordFactory factory) {
        int order = BPlusTreeParams.calcOrder(this.blockSize, factory);
        BPlusTreeParams params = new BPlusTreeParams(order, factory);
        String fnNodes = location.getPath(name, "idn");
        BlockMgr blkMgrNodes = this.createBlockMgr(fnNodes, this.blockSize);
        String fnRecords = location.getPath(name, "dat");
        BlockMgr blkMgrRecords = this.createBlockMgr(fnRecords, this.blockSize);
        return BPlusTree.attach(params, blkMgrNodes, blkMgrRecords);
    }

    protected BlockMgr createBlockMgr(String filename, int blockSize) {
        return BlockMgrFactory.createFile(filename, blockSize);
    }
}

