/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.ext;

import com.hp.hpl.jena.tdb.base.StorageException;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPageBase;
import com.hp.hpl.jena.tdb.index.ext.HashBucketMgr;
import java.nio.ByteBuffer;
import lib.Lib;

public final class HashBucket
extends RecordBufferPageBase {
    public static final int TRIE = 4;
    public static final int BITLEN = 8;
    public static final int FIELD_LENGTH = 8;
    private int trie;
    private int bucketBitLen;
    private HashBucketMgr pageMgr;

    public HashBucket(int id, int hashValue, int bucketBitLen, ByteBuffer byteBuffer, RecordFactory factory, HashBucketMgr hashBucketPageMgr, int count) {
        super(id, 8, byteBuffer, factory, count);
        this.pageMgr = hashBucketPageMgr;
        this.bucketBitLen = bucketBitLen;
        this.trie = hashValue;
    }

    public final int findIndex(Record key) {
        int i = this.getRecordBuffer().find(key);
        return i;
    }

    public final Record find(Record key) {
        int i = this.getRecordBuffer().find(key);
        if (i < 0) {
            return null;
        }
        return this.getRecordBuffer().get(i);
    }

    public final boolean put(Record record) {
        int i = this.findIndex(record);
        if (i >= 0) {
            Record recordOrig = this.getRecordBuffer().get(i);
            if (record.equals(recordOrig)) {
                return false;
            }
            this.getRecordBuffer().set(i, record);
            return true;
        }
        i = Lib.decodeIndex(i);
        if (this.getRecordBuffer().isFull()) {
            throw new StorageException("Bucket overflow");
        }
        this.getRecordBuffer().add(i, record);
        return true;
    }

    public void set(int x, Record record) {
        this.getRecordBuffer().set(x, record);
    }

    public final boolean removeByKey(Record key) {
        int i = this.findIndex(key);
        if (i < 0) {
            return false;
        }
        this.getRecordBuffer().remove(i);
        return true;
    }

    public final boolean isFull() {
        return this.getRecordBuffer().isFull();
    }

    public final boolean isEmpty() {
        return this.getRecordBuffer().isEmpty();
    }

    public final Record get(int idx) {
        if (idx >= this.getRecordBuffer().size()) {
            return null;
        }
        return this.getRecordBuffer().get(idx);
    }

    public final int getTrieValue() {
        return this.trie;
    }

    final void setTrieValue(int newHash) {
        this.trie = newHash;
    }

    public final int getTrieBitLen() {
        return this.bucketBitLen;
    }

    public void setTrieLength(int trieBitLen) {
        this.bucketBitLen = trieBitLen;
    }

    public void setPageMgr(HashBucketMgr pageMgr) {
        this.pageMgr = pageMgr;
    }

    public HashBucketMgr getPageMgr() {
        return this.pageMgr;
    }

    final void incTrieBitLen() {
        ++this.bucketBitLen;
    }

    @Override
    public String toString() {
        return String.format("HashBucket [id=%d, trie=0x%04X, bitlen=%d]: %s", this.getId(), this.getTrieValue(), this.getTrieBitLen(), this.getRecordBuffer().toString());
    }
}

