/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.ext;

import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.ext.ExtHash;
import java.util.Iterator;
import java.util.List;
import lib.Bytes;
import lib.ListUtils;
import lib.RandomLib;
import org.junit.Assert;
import test.ExecGenerator;
import test.Gen;
import test.RepeatExecution;

public class ExtHashTestBase {
    public static final RecordFactory factory = new RecordFactory(4, 4);

    public static void randTests(int maxValue, int maxNumKeys, int iterations, boolean showProgess) {
        ExtHashTest test = new ExtHashTest(maxValue, maxNumKeys);
        RepeatExecution.repeatExecutions(test, iterations, showProgess);
    }

    public static void randTest(int maxValue, int numKeys) {
        int[] r1 = Gen.rand(numKeys, 0, maxValue);
        int[] r2 = Gen.permute(r1, 4 * numKeys);
        ExtHashTestBase.runTest(r1, r2);
    }

    public static void runTest(int[] r1, int[] r2) {
        try {
            ExtHash extHash = ExtHashTestBase.create(r1);
            ExtHashTestBase.check(extHash, r1);
            ExtHashTestBase.delete(extHash, r2);
            ExtHashTestBase.check(extHash, new int[0]);
        }
        catch (RuntimeException ex) {
            System.err.println();
            System.err.printf("int[] r1 = {%s} ;\n", Gen.strings(r1));
            System.err.printf("int[] r2 = {%s}; \n", Gen.strings(r2));
            throw ex;
        }
    }

    public static ExtHash make() {
        return ExtHash.createMem(factory, 128);
    }

    public static Record intToRecord(int v) {
        byte[] key = Bytes.packInt(v);
        byte[] val = Bytes.packInt(v + 100);
        return factory.create(key, val);
    }

    public static Record intToRecordKey(int v) {
        byte[] key = Bytes.packInt(v);
        return factory.create(key);
    }

    public static ExtHash create(int ... recs) {
        ExtHash extHash = ExtHashTestBase.make();
        for (int i : recs) {
            Record r = ExtHashTestBase.intToRecord(i);
            extHash.add(r);
        }
        return extHash;
    }

    public static ExtHash delete(ExtHash extHash, int ... recs) {
        for (int i : recs) {
            Record r = ExtHashTestBase.intToRecord(i);
            extHash.delete(r);
        }
        return extHash;
    }

    public static void check(ExtHash extHash, int ... recs) {
        extHash.check();
        for (int i : recs) {
            Record r = ExtHashTestBase.intToRecordKey(i);
            Assert.assertNotNull((Object)extHash.find(r));
        }
        List<Integer> y = ListUtils.unique(ListUtils.asList(recs));
        int x = (int)extHash.size();
        if (x < 0) {
            x = (int)extHash.sessionTripleCount();
        }
        Assert.assertEquals((long)y.size(), (long)x);
    }

    public static void check(Iterator<Integer> iter, int ... recs) {
        for (int i : recs) {
            Assert.assertTrue((String)"Iterator shorter than test answers", (boolean)iter.hasNext());
            int j = iter.next();
            Assert.assertEquals((long)i, (long)j);
        }
        Assert.assertFalse((String)"Iterator longer than test answers", (boolean)iter.hasNext());
    }

    static class ExtHashTest
    implements ExecGenerator {
        int maxNumKeys;
        int maxValue;

        ExtHashTest(int maxValue, int maxNumKeys) {
            if (maxValue <= maxNumKeys) {
                throw new IllegalArgumentException("ExtHashTest: Max value less than number of keys");
            }
            this.maxValue = maxValue;
            this.maxNumKeys = maxNumKeys;
        }

        @Override
        public void executeOneTest() {
            int numKeys = RandomLib.random.nextInt(this.maxNumKeys) + 1;
            ExtHashTestBase.randTest(this.maxValue, numKeys);
        }
    }
}

