/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.ext;

import com.hp.hpl.jena.tdb.base.StorageException;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.buffer.RecordBuffer;
import com.hp.hpl.jena.tdb.base.file.PlainFile;
import com.hp.hpl.jena.tdb.base.file.PlainFileMem;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.ext.ExtHashIterator;
import com.hp.hpl.jena.tdb.index.ext.HashBucket;
import com.hp.hpl.jena.tdb.index.ext.HashBucketMgr;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import io.IndentedLineBuffer;
import io.IndentedWriter;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Iterator;
import lib.BitsLong;
import lib.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtHash
implements Index {
    private static Logger log = LoggerFactory.getLogger(ExtHash.class);
    public static boolean Debugging = false;
    public static boolean Checking = false;
    public static boolean Logging = false;
    IntBuffer dictionary;
    private int bitLen = 0;
    private long sessionCounter = 0L;
    private final HashBucketMgr hashBucketMgr;
    private final RecordFactory recordFactory;
    private final PlainFile dictionaryFile;
    private HashRecordKey hashFunction = hash4bytes;
    static HashRecordKey hash4bytes = new HashRecordKey(){

        @Override
        public int hashCode(byte[] key) {
            return Bytes.getInt(key);
        }
    };

    public static ExtHash createMem(RecordFactory factory, int bucketSizeBytes) {
        BlockMgr mgr = BlockMgrFactory.createMem("ExtHash", bucketSizeBytes);
        ExtHash eHash = new ExtHash(new PlainFileMem(), factory, mgr);
        return eHash;
    }

    public ExtHash(PlainFile dictionaryBackingFile, RecordFactory recordFactory, BlockMgr blockMgrHashBuckets) {
        this.dictionaryFile = dictionaryBackingFile;
        boolean dictionarySize = true;
        this.dictionary = this.dictionaryFile.ensure(4).asIntBuffer();
        this.recordFactory = recordFactory;
        this.hashBucketMgr = new HashBucketMgr(recordFactory, blockMgrHashBuckets);
        this.hashBucketMgr.valid(0);
        if (!this.hashBucketMgr.valid(0)) {
            int id = this.hashBucketMgr.allocateId();
            if (id != 0) {
                throw new StorageException("ExtHash: First bucket is not id zero");
            }
            HashBucket hb = this.hashBucketMgr.create(id, 0, 0);
            this.dictionary.put(0, id);
            this.bitLen = 0;
            this.hashBucketMgr.put(hb);
        }
    }

    private int trieKey(Record k) {
        int x = this.hashFunction.hashCode(k.getKey());
        return Integer.reverse(x) >>> 1;
    }

    private int trieKey(Record key, int bitLen) {
        return this.trieKey(this.trieKey(key), bitLen);
    }

    private int trieKey(int fullTrie, int bitLen) {
        return fullTrie >>> 31 - bitLen;
    }

    private int bucketId(Record key, int bitLen) {
        int x = this.trieKey(this.trieKey(key), bitLen);
        int id = this.dictionary.get(x);
        return id;
    }

    private static long filesize(int dictionarySize) {
        return 4L * (long)dictionarySize;
    }

    private void resizeDictionary() {
        int oldSize = 1 << this.bitLen;
        int newBitLen = this.bitLen + 1;
        int newSize = 1 << newBitLen;
        if (this.logging()) {
            this.log(">>>>Resize");
            this.log("resize: %d ==> %d", oldSize, newSize);
        }
        IntBuffer newDictionary = this.dictionaryFile.ensure(newSize * 4).asIntBuffer();
        if (this.dictionary != null) {
            for (int i = oldSize - 1; i >= 0; --i) {
                int b = this.dictionary.get(i);
                if (this.logging()) {
                    this.log("Resize: put: (%d, %d)", 2 * i, b);
                }
                newDictionary.put(2 * i, b);
                newDictionary.put(2 * i + 1, b);
            }
        }
        this.dictionary = newDictionary;
        this.bitLen = newBitLen;
        if (this.logging()) {
            this.dump();
            this.log(this);
            this.log("<<<<Resize");
        }
        this.internalCheck();
    }

    final int getBucketId(int dictionaryIdx) {
        return this.dictionary.get(dictionaryIdx);
    }

    final HashBucket getBucket(int blockId) {
        return this.hashBucketMgr.get(blockId);
    }

    public final int dictionarySize() {
        return this.dictionary.capacity();
    }

    @Override
    public boolean contains(Record key) {
        return this.find(key) != null;
    }

    @Override
    public Record find(Record key) {
        if (this.logging()) {
            this.log(">> get(%s)", key);
        }
        int blockId = this.bucketId(key, this.bitLen);
        HashBucket bucket = this.hashBucketMgr.get(blockId);
        Record value = bucket.find(key);
        if (this.logging()) {
            this.log("<< get(%s) -> %s", key.getKey(), value);
        }
        return value;
    }

    @Override
    public boolean add(Record record) {
        int h;
        boolean b;
        if (this.logging()) {
            this.log(">> add(%s)", record);
        }
        if (b = this.put(record, h = this.trieKey(record))) {
            ++this.sessionCounter;
        }
        if (this.logging()) {
            this.log("<< add(%s)", record);
            this.dump();
        }
        this.internalCheck();
        return b;
    }

    @Override
    public boolean delete(Record record) {
        if (this.logging()) {
            this.log(">> remove(%s)", record);
        }
        int blockId = this.bucketId(record, this.bitLen);
        HashBucket bucket = this.hashBucketMgr.get(blockId);
        boolean b = bucket.removeByKey(record);
        this.hashBucketMgr.put(bucket);
        if (b) {
            --this.sessionCounter;
        }
        this.internalCheck();
        if (this.logging()) {
            this.log("<< remove(%s)", record);
        }
        return b;
    }

    @Override
    public RecordFactory getRecordFactory() {
        return this.recordFactory;
    }

    @Override
    public Iterator<Record> iterator() {
        return new ExtHashIterator(this);
    }

    @Override
    public boolean isEmpty() {
        if (this.dictionary.limit() == 1) {
            HashBucket b = this.hashBucketMgr.get(1);
            return b.isEmpty();
        }
        return false;
    }

    @Override
    public long size() {
        return this.count();
    }

    public long count() {
        HashSet<Integer> seen = new HashSet<Integer>();
        long count = 0L;
        for (int i = 0; i < this.dictionary.capacity(); ++i) {
            int id = this.dictionary.get(i);
            if (seen.contains(id)) continue;
            seen.add(id);
            HashBucket bucket = this.hashBucketMgr.get(id);
            count += (long)bucket.getCount();
        }
        return count;
    }

    @Override
    public void sync(boolean force) {
        this.hashBucketMgr.getBlockMgr().sync(force);
        this.dictionaryFile.sync(force);
    }

    @Override
    public long sessionTripleCount() {
        return this.sessionCounter;
    }

    @Override
    public void close() {
        this.hashBucketMgr.getBlockMgr().close();
        this.dictionaryFile.close();
    }

    private boolean put(Record record, int hash) {
        int dictIdx;
        int blockId;
        HashBucket bucket;
        if (this.logging()) {
            this.log("put(%s,0x%08X)", record, hash);
        }
        if (!(bucket = this.hashBucketMgr.get(blockId = this.dictionary.get(dictIdx = this.trieKey(hash, this.bitLen)))).isFull()) {
            if (Debugging) {
                System.out.printf("Insert [(0x%04X) %s]: %d\n", hash, record, bucket.getId());
            }
            boolean b = bucket.put(record);
            this.hashBucketMgr.put(bucket);
            return b;
        }
        if (Debugging) {
            System.out.printf("Bucket full: %d\n", bucket.getId());
        }
        if (this.bitLen == bucket.getTrieBitLen()) {
            if (Debugging) {
                System.out.printf("Bucket can't be split\n", new Object[0]);
            }
            int x = this.dictionarySize();
            this.resizeDictionary();
            if (Debugging) {
                System.out.printf("Resize: %d -> %d\n", x, this.dictionarySize());
            }
            return this.put(record, hash);
        }
        if (Debugging) {
            System.out.printf("Split bucket: %d\n", bucket.getId());
        }
        this.splitAndReorganise(bucket, dictIdx, blockId, hash);
        return this.put(record, hash);
    }

    private void splitAndReorganise(HashBucket bucket, int dictionaryIdx, int bucketId, int hash) {
        if (this.logging()) {
            this.log("splitAndReorganise: idx=%d, id=%d, bitLen=%d, bucket.hashLength=%d", dictionaryIdx, bucketId, this.bitLen, bucket.getTrieBitLen());
            this.dump();
        }
        if (Checking) {
            if (bucket.getTrieBitLen() >= this.bitLen) {
                this.error("splitAndReorganise: idx=0x%X : hash=0x%X[0x%X,0x%X] : Hash not shorter : %s", dictionaryIdx, hash, this.trieKey(hash, bucket.getTrieBitLen()), bucket.getTrieValue(), bucket);
            }
            if (this.trieKey(hash, bucket.getTrieBitLen()) != bucket.getTrieValue()) {
                this.error("splitAndReorganise: idx=0x%X : hash=0x%X[0x%X,0x%X] : Inconsistency : %s", dictionaryIdx, hash, this.trieKey(hash, bucket.getTrieBitLen()), bucket.getTrieValue(), bucket);
            }
        }
        int bucketHash = bucket.getTrieValue();
        int bucketHashLength = bucket.getTrieBitLen();
        HashBucket bucket2 = this.split(bucketId, bucket);
        int trieUpperRoot = (bucketHash << 1 | 1) << this.bitLen - bucketHashLength - 1;
        int trieUpperRange = 1 << this.bitLen - bucketHashLength - 1;
        for (int j = 0; j < trieUpperRange; ++j) {
            int k = trieUpperRoot | j;
            if (this.logging()) {
                this.log("Point to split bucket: 0x%04X", k);
            }
            if (Checking) {
                int id;
                HashBucket hb;
                if ((trieUpperRoot & j) != 0) {
                    this.error("put: idx=%d : trieRoot=0x%X, sub=%d: Broken trie pattern ", dictionaryIdx, trieUpperRoot, j);
                }
                if (!BitsLong.isSet(k, this.bitLen - (bucketHashLength + 1))) {
                    this.error("put: Broken trie pattern (0x%X,%d)", trieUpperRoot, j);
                }
                if ((hb = this.hashBucketMgr.get(id = this.dictionary.get(k))).getId() != bucket.getId()) {
                    this.error("put: Wrong bucket at trie 0x%X %d: (%d,%d)", trieUpperRoot, j, hb.getId(), bucket.getId());
                }
            }
            this.dictionary.put(k, bucket2.getId());
        }
        if (this.logging()) {
            this.log("Reorg complete");
            this.dump();
        }
    }

    private HashBucket split(int bucketId, HashBucket bucket) {
        if (this.logging()) {
            this.log("split: Bucket %d : size: %d; Bucket bitlength %d", bucketId, bucket.getCount(), bucket.getTrieBitLen());
            this.log("split: %s", bucket);
        }
        bucket.incTrieBitLen();
        int hash1 = bucket.getTrieValue() << 1;
        int hash2 = bucket.getTrieValue() << 1 | 1;
        bucket.setTrieValue(hash1);
        if (this.logging()) {
            this.log("split: bucket hashes 0x%04X 0x%04X", hash1, hash2);
        }
        int id2 = this.hashBucketMgr.allocateId();
        HashBucket bucket2 = this.hashBucketMgr.create(id2, hash2, bucket.getTrieBitLen());
        if (this.logging()) {
            this.log("New bucket: %s", bucket2);
        }
        RecordBuffer rBuff1 = bucket.getRecordBuffer();
        RecordBuffer rBuff2 = bucket2.getRecordBuffer();
        int idx1 = 0;
        int idx2 = 0;
        for (int i = 0; i < rBuff1.size(); ++i) {
            Record r = rBuff1.get(i);
            int x = this.trieKey(r, bucket.getTrieBitLen());
            if (x == hash1) {
                if (this.logging()) {
                    this.log("Allocate index %d to bucket1", i);
                }
                if (idx1 != i) {
                    rBuff1.set(idx1, r);
                }
                ++idx1;
                continue;
            }
            if (x == hash2) {
                if (this.logging()) {
                    this.log("Allocate index %d to bucket2", i);
                }
                rBuff2.add(r);
                ++idx2;
                continue;
            }
            this.error("Bad trie for allocation to split buckets", new Object[0]);
        }
        rBuff1.clear(idx1, bucket.getCount() - idx1);
        rBuff1.setSize(idx1);
        if (this.logging()) {
            this.log("split: Lower bucket: %s", bucket);
            this.log("split: Upper bucket: %s", bucket2);
        }
        this.hashBucketMgr.put(bucket);
        this.hashBucketMgr.put(bucket2);
        return bucket2;
    }

    public String toString() {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        this.dump(buff);
        return buff.asString();
    }

    public void dump() {
        this.dump(IndentedWriter.stdout);
        IndentedWriter.stdout.ensureStartOfLine();
        IndentedWriter.stdout.flush();
    }

    private void dump(IndentedWriter out) {
        out.printf("Bitlen      = %d \n", this.bitLen);
        out.printf("Dictionary  = %d \n", 1 << this.bitLen);
        out.incIndent(4);
        for (int i = 0; i < 1 << this.bitLen; ++i) {
            out.ensureStartOfLine();
            int id = this.dictionary.get(i);
            HashBucket bucket = this.hashBucketMgr.get(id);
            out.printf("[%d] %02d %s", i, id, bucket);
        }
        out.decIndent(4);
    }

    @Override
    public void check() {
        this.performCheck();
    }

    private final void internalCheck() {
        if (Checking) {
            this.performCheck();
        }
    }

    private final void performCheck() {
        int len = 1 << this.bitLen;
        int d = this.dictionary.limit();
        if (len != d) {
            this.error("Dictionary size = %d : expected = %d", d, len);
        }
        HashSet<Integer> seen = new HashSet<Integer>();
        for (int i = 0; i < d; ++i) {
            int id = this.dictionary.get(i);
            if (seen.contains(id)) continue;
            seen.add(id);
            HashBucket bucket = this.hashBucketMgr.get(id);
            this.performCheck(i, bucket);
        }
    }

    private void performCheck(int idx, HashBucket bucket) {
        int i;
        int tmp;
        if (bucket.getTrieBitLen() > this.bitLen) {
            this.error("[%d] Bucket %d has bit length longer than the dictionary's (%d, %d)", idx, bucket.getId(), bucket.getTrieBitLen(), this.bitLen);
        }
        if ((tmp = idx >>> this.bitLen - bucket.getTrieBitLen()) != bucket.getTrieValue()) {
            this.error("[%d] Bucket %d : hash prefix 0x%X, expected 0x%X : %s", idx, bucket.getId(), bucket.getTrieValue(), tmp, bucket);
        }
        Record prevKey = Record.NO_REC;
        for (i = 0; i < bucket.getCount(); ++i) {
            Record rec = bucket.get(i);
            if (prevKey != Record.NO_REC && Record.keyLT(rec, prevKey)) {
                this.error("[%d] Bucket %d: Not sorted (slot %d) : %s", idx, bucket.getId(), i, bucket);
            }
            prevKey = rec;
            int x = this.trieKey(rec, bucket.getTrieBitLen());
            if (x == bucket.getTrieValue()) continue;
            this.error("[%d] Bucket %d: Key (0x%04X) does not match the hash (0x%04X) : %s", idx, bucket.getId(), x, bucket.getTrieValue(), bucket);
        }
        if (SystemTDB.NullOut) {
            for (i = bucket.getCount(); i < bucket.getMaxSize(); ++i) {
                if (bucket.getRecordBuffer().isClear(i)) continue;
                this.error("[%d] Bucket %d : overspill at [%d]: %s", idx, bucket.getId(), i, bucket);
            }
        }
    }

    private void error(String msg, Object ... args) {
        msg = String.format(msg, args);
        log.error(msg);
        throw new StorageException(msg);
    }

    private final boolean logging() {
        return Logging;
    }

    private final void log(String format, Object ... args) {
        log.debug(String.format(format, args));
    }

    private final void log(Object obj) {
        log.debug(obj.toString());
    }

    static interface HashRecordKey {
        public int hashCode(byte[] var1);
    }
}

