/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.btree;

import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.btree.BTree;
import com.hp.hpl.jena.tdb.index.btree.BTreeParams;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import test.BaseTest;

public class TestBTreeLong
extends BaseTest {
    static RecordFactory recordFactory;
    static final int LongRecordLength = 16;
    static boolean b;

    @BeforeClass
    public static void before() {
        recordFactory = new RecordFactory(16, 0);
        BTreeParams.CheckingNode = true;
        b = SystemTDB.NullOut;
        SystemTDB.NullOut = true;
    }

    @AfterClass
    public static void after() {
        SystemTDB.NullOut = b;
    }

    @Test
    public void record1() {
        BTree bTree = TestBTreeLong.create(2);
        Record r = TestBTreeLong.record(1);
        bTree.add(r);
    }

    @Test
    public void record2() {
        BTree bTree = TestBTreeLong.create(2);
        Record r = TestBTreeLong.record(1);
        bTree.add(r);
        TestBTreeLong.assertTrue((boolean)bTree.contains(r));
        bTree.add(r);
        TestBTreeLong.assertTrue((boolean)bTree.contains(r));
        TestBTreeLong.assertEquals((long)1L, (long)bTree.sessionTripleCount());
        bTree.delete(r);
        TestBTreeLong.assertFalse((boolean)bTree.contains(r));
        TestBTreeLong.assertEquals((long)0L, (long)bTree.sessionTripleCount());
    }

    @Test
    public void record3() {
        BTree bTree = TestBTreeLong.create(2);
        Record r1 = TestBTreeLong.record(1);
        Record r2 = TestBTreeLong.record(10);
        bTree.add(r1);
        TestBTreeLong.assertTrue((boolean)bTree.contains(r1));
        bTree.add(r2);
        TestBTreeLong.assertTrue((boolean)bTree.contains(r2));
        TestBTreeLong.assertEquals((long)2L, (long)bTree.sessionTripleCount());
        bTree.delete(r1);
        TestBTreeLong.assertFalse((boolean)bTree.contains(r1));
        TestBTreeLong.assertTrue((boolean)bTree.contains(r2));
        TestBTreeLong.assertEquals((long)1L, (long)bTree.sessionTripleCount());
    }

    @Test
    public void record4() {
        BTree bTree = TestBTreeLong.create(2);
        for (int i = 0; i < 5; ++i) {
            bTree.add(TestBTreeLong.record(i));
        }
        Record r1 = TestBTreeLong.record(10);
        Record r2 = TestBTreeLong.record(20);
        bTree.add(r1);
        TestBTreeLong.assertTrue((boolean)bTree.contains(r1));
        bTree.add(r2);
        TestBTreeLong.assertTrue((boolean)bTree.contains(r2));
        TestBTreeLong.assertEquals((long)7L, (long)bTree.sessionTripleCount());
        bTree.delete(r1);
        TestBTreeLong.assertFalse((boolean)bTree.contains(r1));
        TestBTreeLong.assertTrue((boolean)bTree.contains(r2));
        TestBTreeLong.assertEquals((long)6L, (long)bTree.sessionTripleCount());
    }

    static BTree create(int order) {
        BTree bTree = BTree.makeMem(order, 16, 0);
        return bTree;
    }

    static Record record(int v) {
        byte[] data = new byte[16];
        for (int i = 0; i < 16; ++i) {
            data[i] = (byte)(i + v);
        }
        return recordFactory.create(data);
    }
}

