/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.btree;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.btree.BTreeNode;
import com.hp.hpl.jena.tdb.index.btree.BTreePageMgr;
import com.hp.hpl.jena.tdb.index.btree.BTreeParams;
import iterator.Iter;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BTree
implements Iterable<Record>,
RangeIndex {
    private static Logger log = LoggerFactory.getLogger(BTree.class);
    private long sessionCounter = 0L;
    private int rootIdx;
    BTreeNode root;
    private BTreePageMgr pageMgr;
    private BTreeParams bTreeParams;

    public static BTree makeMem(int N, int keyLength, int valueLength) {
        return BTree.makeMem(null, N, keyLength, valueLength);
    }

    public static BTree makeMem(String name, int N, int keyLength, int valueLength) {
        BTreeParams params = new BTreeParams(N, keyLength, valueLength);
        BlockMgr mgr = BlockMgrFactory.createMem(name, params.getBlockSize());
        return new BTree(params, mgr);
    }

    public BTree(BTreeParams bTreeParams, BlockMgr blkMgr) {
        this.bTreeParams = bTreeParams;
        this.pageMgr = new BTreePageMgr(this, blkMgr);
        if (this.pageMgr.valid(0)) {
            this.root = this.pageMgr.getRoot(this.rootIdx);
            this.rootIdx = this.root.id;
            this.sessionCounter = 0L;
            log.debug("Existing BTree: crude implementation of size");
        } else {
            this.root = this.pageMgr.createRoot();
            this.rootIdx = this.root.id;
            this.sessionCounter = 0L;
            if (BTreeParams.CheckingNode) {
                this.root.checkNodeDeep();
            }
            this.pageMgr.put(this.root);
        }
    }

    BTreeParams getParams() {
        return this.bTreeParams;
    }

    BTreePageMgr getPageMgr() {
        return this.pageMgr;
    }

    @Override
    public RecordFactory getRecordFactory() {
        return this.bTreeParams.recordFactory;
    }

    @Override
    public Record find(Record record) {
        Record v = this.root.search(record);
        if (log.isDebugEnabled()) {
            log.debug(String.format("find(%s) ==> %s", record, v));
        }
        return v;
    }

    @Override
    public boolean contains(Record record) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("contains(%s)", record));
        }
        return this.root.search(record) != null;
    }

    @Override
    public Record minKey() {
        return this.root.minRecord();
    }

    @Override
    public Record maxKey() {
        return this.root.maxRecord();
    }

    @Override
    public boolean add(Record record) {
        return this.addAndReturnOld(record) == null;
    }

    public Record addAndReturnOld(Record record) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("add(%s)", record));
        }
        this.pageMgr.startUpdate();
        Record r = this.root.insert(record);
        if (r == null) {
            ++this.sessionCounter;
        }
        if (BTreeParams.CheckingBTree) {
            this.root.checkNodeDeep();
        }
        this.pageMgr.finishUpdate();
        return r;
    }

    @Override
    public boolean delete(Record record) {
        return this.deleteAndReturnOld(record) != null;
    }

    public Record deleteAndReturnOld(Record record) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("delete(%s)", record));
        }
        this.pageMgr.startUpdate();
        Record r = this.root.delete(record);
        if (r != null) {
            --this.sessionCounter;
        }
        if (BTreeParams.CheckingBTree) {
            this.root.checkNodeDeep();
        }
        this.pageMgr.finishUpdate();
        return r;
    }

    @Override
    public Iterator<Record> iterator() {
        return this.root.iterator();
    }

    @Override
    public Iterator<Record> iterator(Record fromRec, Record toRec) {
        return this.root.iterator(fromRec, toRec);
    }

    @Override
    public boolean isEmpty() {
        return this.pageMgr.getBlockMgr().isEmpty();
    }

    @Override
    public void sync(boolean force) {
        if (this.pageMgr.getBlockMgr() != null) {
            this.pageMgr.getBlockMgr().sync(force);
        }
    }

    @Override
    public void close() {
        if (this.pageMgr.getBlockMgr() != null) {
            this.pageMgr.getBlockMgr().close();
        }
    }

    @Override
    public long size() {
        Iterator<Record> iter = this.iterator();
        return Iter.count(iter);
    }

    @Override
    public long sessionTripleCount() {
        return this.sessionCounter;
    }

    public long sizeByCounting() {
        return this.root.sizeByCounting();
    }

    @Override
    public void check() {
        this.root.checkNodeDeep();
    }

    public void dump() {
        this.root.dump();
    }
}

