/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.buffer.RecordBuffer;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.base.record.RecordLib;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPage;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPageMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreePage;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeRecords;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import junit.TestBase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestBPTreeRecords
extends TestBase {
    private static boolean oldNullOut;
    private static boolean oldCheckingNode;
    private static boolean oldCheckingBTree;
    private static int blockSize;
    private static RecordFactory recordFactory;
    private static int bufSizeRecord;
    private static BlockMgr blkMgrRecords;
    private static RecordBufferPageMgr recordBufferPageMgr;
    private static BPlusTree bPlusTree;

    @BeforeClass
    public static void beforeClass() {
        oldNullOut = SystemTDB.NullOut;
        SystemTDB.NullOut = true;
        oldCheckingNode = BPlusTreeParams.CheckingNode;
        BPlusTreeParams.CheckingNode = true;
        oldCheckingBTree = BPlusTreeParams.CheckingTree;
        BPlusTreeParams.CheckingTree = true;
        blockSize = 32;
        recordFactory = new RecordFactory(4, 0);
        bufSizeRecord = RecordBufferPage.calcRecordSize(recordFactory, blockSize);
        blkMgrRecords = BlockMgrFactory.createMem("BPTreeRecords", blockSize);
        recordBufferPageMgr = new RecordBufferPageMgr(recordFactory, blkMgrRecords);
        bPlusTree = BPlusTree.dummy(new BPlusTreeParams(3, recordFactory), null, blkMgrRecords);
    }

    @AfterClass
    public static void afterClass() {
        SystemTDB.NullOut = oldNullOut;
        BPlusTreeParams.CheckingTree = oldCheckingNode;
        BPlusTreeParams.CheckingTree = oldCheckingBTree;
    }

    @Test
    public void bpt_records_1() {
        BPTreeRecords bpr = TestBPTreeRecords.make();
        TestBPTreeRecords.fill(bpr);
        TestBPTreeRecords.check(bpr);
    }

    @Test
    public void bpt_records_2() {
        BPTreeRecords bpr = TestBPTreeRecords.make();
        TestBPTreeRecords.fill(bpr);
        int s = bpr.getCount();
        TestBPTreeRecords.assertTrue((boolean)bpr.isFull());
        BPTreePage z = bpr.split();
        TestBPTreeRecords.assertTrue((boolean)(z instanceof BPTreeRecords));
        TestBPTreeRecords.assertEquals((long)s, (long)(z.getCount() + bpr.getCount()));
        TestBPTreeRecords.check(bpr);
        TestBPTreeRecords.check((BPTreeRecords)z);
    }

    @Test
    public void bpt_records_3() {
        BPTreeRecords bpr = TestBPTreeRecords.make();
        int i = 0;
        while (bpr.getCount() < bpr.getMaxSize()) {
            TestBPTreeRecords.insert(bpr, i + 32);
            ++i;
        }
        TestBPTreeRecords.check(bpr);
    }

    @Test
    public void bpt_records_4() {
        BPTreeRecords bpr = TestBPTreeRecords.make();
        for (int i = bpr.getMaxSize() - 1; i >= 0; --i) {
            TestBPTreeRecords.insert(bpr, i + 32);
        }
        TestBPTreeRecords.check(bpr);
    }

    @Test
    public void bpt_records_5() {
        BPTreeRecords bpr = TestBPTreeRecords.make();
        int N = bpr.getMaxSize();
        for (int i = bpr.getMaxSize() - 1; i >= 0; --i) {
            TestBPTreeRecords.insert(bpr, i + 32);
        }
        TestBPTreeRecords.delete(bpr, 33);
        TestBPTreeRecords.assertEquals((long)(N - 1), (long)bpr.getCount());
        TestBPTreeRecords.check(bpr);
        TestBPTreeRecords.delete(bpr, 34);
        TestBPTreeRecords.assertEquals((long)(N - 2), (long)bpr.getCount());
        TestBPTreeRecords.check(bpr);
        TestBPTreeRecords.delete(bpr, bpr.getLowRecord());
        TestBPTreeRecords.assertEquals((long)(N - 3), (long)bpr.getCount());
        TestBPTreeRecords.check(bpr);
        bpr.internalDelete(bpr.getHighRecord());
        TestBPTreeRecords.assertEquals((long)(N - 4), (long)bpr.getCount());
        TestBPTreeRecords.check(bpr);
    }

    @Test
    public void bpt_records_6() {
        BPTreeRecords bpr = TestBPTreeRecords.make();
        TestBPTreeRecords.fill(bpr);
        TestBPTreeRecords.assertNull((Object)bpr.internalSearch(RecordLib.intToRecord(32)));
        Record r = RecordLib.intToRecord(50);
        Record r2 = TestBPTreeRecords.search(bpr, r);
        TestBPTreeRecords.assertTrue((boolean)Record.keyEQ(r, r2));
        r = bpr.getLowRecord();
        r2 = TestBPTreeRecords.search(bpr, r);
        TestBPTreeRecords.assertTrue((boolean)Record.keyEQ(r, r2));
        r = bpr.getHighRecord();
        r2 = TestBPTreeRecords.search(bpr, r);
        TestBPTreeRecords.assertTrue((boolean)Record.keyEQ(r, r2));
    }

    @Test
    public void bpt_shift_1() {
        BPTreeRecords bpr1 = TestBPTreeRecords.make();
        BPTreeRecords bpr2 = TestBPTreeRecords.make();
        TestBPTreeRecords.insert(bpr1, 10);
        Record r = bpr1.shiftRight(bpr2, null);
        TestBPTreeRecords.assertNull((Object)r);
        TestBPTreeRecords.contains(bpr1, new int[0]);
        TestBPTreeRecords.contains(bpr2, 10);
    }

    @Test
    public void bpt_shift_2() {
        BPTreeRecords bpr1 = TestBPTreeRecords.make();
        BPTreeRecords bpr2 = TestBPTreeRecords.make();
        TestBPTreeRecords.insert(bpr1, 10);
        Record r = bpr2.shiftLeft(bpr1, null);
        TestBPTreeRecords.assertTrue((boolean)Record.keyEQ(r, RecordLib.intToRecord(10)));
        TestBPTreeRecords.contains(bpr1, new int[0]);
        TestBPTreeRecords.contains(bpr2, 10);
    }

    @Test
    public void bpt_shift_3() {
        BPTreeRecords bpr1 = TestBPTreeRecords.make();
        BPTreeRecords bpr2 = TestBPTreeRecords.make();
        TestBPTreeRecords.insert(bpr1, 10, 20);
        TestBPTreeRecords.insert(bpr2, 99);
        Record r = bpr1.shiftRight(bpr2, null);
        TestBPTreeRecords.assertTrue((String)(r + " != " + RecordLib.intToRecord(10)), (boolean)Record.keyEQ(r, RecordLib.intToRecord(10)));
        TestBPTreeRecords.contains(bpr1, 10);
        TestBPTreeRecords.contains(bpr2, 20, 99);
    }

    @Test
    public void bpt_shift_4() {
        BPTreeRecords bpr1 = TestBPTreeRecords.make();
        BPTreeRecords bpr2 = TestBPTreeRecords.make();
        TestBPTreeRecords.insert(bpr1, 10, 20);
        TestBPTreeRecords.insert(bpr2, 5);
        Record r = bpr2.shiftLeft(bpr1, null);
        TestBPTreeRecords.assertTrue((boolean)Record.keyEQ(r, RecordLib.intToRecord(10)));
        TestBPTreeRecords.contains(bpr1, 20);
        TestBPTreeRecords.contains(bpr2, 5, 10);
    }

    @Test
    public void bpt_merge_1() {
        BPTreeRecords bpr1 = TestBPTreeRecords.make();
        BPTreeRecords bpr2 = TestBPTreeRecords.make();
        TestBPTreeRecords.insert(bpr1, 10, 20);
        TestBPTreeRecords.insert(bpr2, 99);
        BPTreeRecords bpr3 = (BPTreeRecords)bpr1.merge(bpr2, null);
        TestBPTreeRecords.contains(bpr1, 10, 20, 99);
        TestBPTreeRecords.contains(bpr2, new int[0]);
        TestBPTreeRecords.assertSame((Object)bpr1, (Object)bpr3);
    }

    @Test
    public void bpt_merge_2() {
        BPTreeRecords bpr1 = TestBPTreeRecords.make();
        BPTreeRecords bpr2 = TestBPTreeRecords.make();
        TestBPTreeRecords.insert(bpr1, 10, 20);
        TestBPTreeRecords.insert(bpr2, 5);
        BPTreeRecords bpr3 = (BPTreeRecords)bpr2.merge(bpr1, null);
        TestBPTreeRecords.contains(bpr1, new int[0]);
        TestBPTreeRecords.contains(bpr2, 5, 10, 20);
        TestBPTreeRecords.assertSame((Object)bpr2, (Object)bpr3);
    }

    private static void check(BPTreeRecords bpr) {
        TestBPTreeRecords.assertTrue((bpr.getCount() >= 0 ? 1 : 0) != 0);
        TestBPTreeRecords.assertTrue((bpr.getCount() <= bpr.getMaxSize() ? 1 : 0) != 0);
        TestBPTreeRecords.assertEquals((Object)bpr.getRecordBuffer().getLow(), (Object)bpr.getLowRecord());
        TestBPTreeRecords.assertEquals((Object)bpr.getRecordBuffer().getHigh(), (Object)bpr.getHighRecord());
        for (int i = 1; i < bpr.getCount(); ++i) {
            Record r1 = bpr.getRecordBuffer().get(i - 1);
            Record r2 = bpr.getRecordBuffer().get(i);
            TestBPTreeRecords.assertTrue((boolean)Record.keyLE(r1, r2));
        }
    }

    private static Record search(BPTreeRecords bpr, int x) {
        return TestBPTreeRecords.search(bpr, RecordLib.intToRecord(x));
    }

    private static Record search(BPTreeRecords bpr, Record r) {
        return bpr.internalSearch(r);
    }

    private static void insert(BPTreeRecords bpr, int ... values) {
        for (int i = 0; i < values.length; ++i) {
            bpr.internalInsert(RecordLib.intToRecord(values[i]));
        }
    }

    private static void insert(BPTreeRecords bpr, Record r) {
        bpr.internalInsert(r);
    }

    private static void delete(BPTreeRecords bpr, int ... values) {
        for (int i = 0; i < values.length; ++i) {
            TestBPTreeRecords.delete(bpr, RecordLib.intToRecord(values[i]));
        }
    }

    private static void delete(BPTreeRecords bpr, Record r) {
        bpr.internalDelete(r);
    }

    private static void contains(BPTreeRecords bpr, int ... values) {
        TestBPTreeRecords.assertEquals((long)values.length, (long)bpr.getCount());
        for (int i = 1; i < values.length; ++i) {
            TestBPTreeRecords.assertTrue((Record.compareByKeyValue(RecordLib.intToRecord(values[i]), bpr.getRecordBuffer().get(i)) == 0 ? 1 : 0) != 0);
        }
    }

    private static BPTreeRecords make() {
        int id = recordBufferPageMgr.allocateId();
        RecordBufferPage page = recordBufferPageMgr.create(id);
        return new BPTreeRecords(bPlusTree, page);
    }

    private static void fill(BPTreeRecords bpr) {
        RecordBuffer rb = bpr.getRecordBuffer();
        int i = 0;
        while (rb.size() < rb.maxSize()) {
            TestBPTreeRecords.insert(bpr, i + 48);
            ++i;
        }
    }
}

