/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPage;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPageMgr;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeNode;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeNodeMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeRecordsMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import iterator.Iter;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPlusTree
implements Iterable<Record>,
RangeIndex {
    private static Logger log = LoggerFactory.getLogger(BPlusTree.class);
    private long sessionCounter = 0L;
    private int rootIdx;
    BPTreeNode root;
    private BPTreeNodeMgr nodeManager;
    private BPTreeRecordsMgr recordsMgr;
    private BPlusTreeParams bpTreeParams;

    public static BPlusTree attach(BPlusTreeParams params, BlockMgr blkMgrNodes, BlockMgr blkMgrLeaves) {
        BPlusTree bpt = new BPlusTree(params, blkMgrNodes, blkMgrLeaves);
        bpt.attach();
        return bpt;
    }

    public static BPlusTree makeMem(int order, int minRecords, int keyLength, int valueLength) {
        return BPlusTree.makeMem(null, order, minRecords, keyLength, valueLength);
    }

    public static BPlusTree makeMem(String name, int order, int minRecords, int keyLength, int valueLength) {
        BPlusTreeParams params = new BPlusTreeParams(order, keyLength, valueLength);
        int maxRecords = 2 * minRecords;
        int blkSize = RecordBufferPage.calcBlockSize(params.getRecordFactory(), maxRecords);
        BlockMgr mgr1 = BlockMgrFactory.createMem(name + "(nodes)", params.getBlockSize());
        BlockMgr mgr2 = BlockMgrFactory.createMem(name + "(records)", blkSize);
        BPlusTree bpTree = BPlusTree.attach(params, mgr1, mgr2);
        return bpTree;
    }

    public static BPlusTree dummy(BPlusTreeParams params, BlockMgr blkMgrNodes, BlockMgr blkMgrLeaves) {
        return new BPlusTree(params, blkMgrNodes, blkMgrLeaves);
    }

    private BPlusTree(BPlusTreeParams params) {
        this.bpTreeParams = params;
    }

    BPlusTree(int N, int recordLength, BlockMgr blkMgrNodes, BlockMgr blkMgrLeaves) {
        this(new BPlusTreeParams(N, recordLength, 0), blkMgrNodes, blkMgrLeaves);
    }

    BPlusTree(BPlusTreeParams params, BlockMgr blkMgrNodes, BlockMgr blkMgrLeaves) {
        this.bpTreeParams = params;
        this.nodeManager = new BPTreeNodeMgr(this, blkMgrNodes);
        RecordBufferPageMgr recordPageMgr = new RecordBufferPageMgr(params.getRecordFactory(), blkMgrLeaves);
        this.recordsMgr = new BPTreeRecordsMgr(this, recordPageMgr);
    }

    void attach() {
        if (this.nodeManager.valid(0)) {
            this.root = this.nodeManager.getRoot(this.rootIdx);
            this.rootIdx = this.root.getId();
            this.sessionCounter = 0L;
        } else {
            this.root = this.nodeManager.createRoot();
            this.rootIdx = this.root.getId();
            this.sessionCounter = 0L;
            if (BPlusTreeParams.CheckingNode) {
                this.root.checkNodeDeep();
            }
        }
    }

    public BPlusTreeParams getParams() {
        return this.bpTreeParams;
    }

    public BPTreeNodeMgr getNodeManager() {
        return this.nodeManager;
    }

    public BPTreeRecordsMgr getRecordsMgr() {
        return this.recordsMgr;
    }

    @Override
    public RecordFactory getRecordFactory() {
        return this.bpTreeParams.recordFactory;
    }

    @Override
    public Record find(Record record) {
        Record v = this.root.search(record);
        if (BPlusTree.logging()) {
            log.debug(String.format("find(%s) ==> %s", record, v));
        }
        return v;
    }

    @Override
    public boolean contains(Record record) {
        if (BPlusTree.logging()) {
            log.debug(String.format("contains(%s)", record));
        }
        return this.root.search(record) != null;
    }

    @Override
    public Record minKey() {
        return this.root.minRecord();
    }

    @Override
    public Record maxKey() {
        return this.root.maxRecord();
    }

    @Override
    public boolean add(Record record) {
        return this.addAndReturnOld(record) == null;
    }

    public Record addAndReturnOld(Record record) {
        if (BPlusTree.logging()) {
            log.debug(String.format("add(%s)", record));
        }
        this.nodeManager.startUpdate();
        Record r = this.root.insert(record);
        if (r == null) {
            ++this.sessionCounter;
        }
        if (BPlusTreeParams.CheckingTree) {
            this.root.checkNodeDeep();
        }
        this.nodeManager.finishUpdate();
        return r;
    }

    @Override
    public boolean delete(Record record) {
        return this.deleteAndReturnOld(record) != null;
    }

    public Record deleteAndReturnOld(Record record) {
        if (BPlusTree.logging()) {
            log.debug(String.format("delete(%s)", record));
        }
        this.nodeManager.startUpdate();
        Record r = this.root.delete(record);
        if (r != null) {
            --this.sessionCounter;
        }
        if (BPlusTreeParams.CheckingTree) {
            this.root.checkNodeDeep();
        }
        this.nodeManager.finishUpdate();
        return r;
    }

    @Override
    public Iterator<Record> iterator() {
        return this.root.iterator();
    }

    @Override
    public Iterator<Record> iterator(Record fromRec, Record toRec) {
        return this.root.iterator(fromRec, toRec);
    }

    @Override
    public boolean isEmpty() {
        return this.nodeManager.getBlockMgr().isEmpty();
    }

    @Override
    public void sync(boolean force) {
        if (this.nodeManager.getBlockMgr() != null) {
            this.nodeManager.getBlockMgr().sync(force);
        }
        if (this.recordsMgr.getBlockMgr() != null) {
            this.recordsMgr.getBlockMgr().sync(force);
        }
    }

    @Override
    public void close() {
        if (this.nodeManager.getBlockMgr() != null) {
            this.nodeManager.getBlockMgr().close();
        }
        if (this.recordsMgr.getBlockMgr() != null) {
            this.recordsMgr.getBlockMgr().close();
        }
    }

    @Override
    public long sessionTripleCount() {
        return this.sessionCounter;
    }

    @Override
    public long size() {
        Iterator<Record> iter = this.iterator();
        return Iter.count(iter);
    }

    long sizeByCounting() {
        return this.root.size();
    }

    @Override
    public void check() {
        this.root.checkNodeDeep();
    }

    public void dump() {
        this.root.dump();
    }

    private static final boolean logging() {
        return BPlusTreeParams.logging(log);
    }
}

