/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPage;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPageMgr;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeRecords;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;

public final class BPTreeRecordsMgr {
    private BPlusTree bpTree;
    private RecordBufferPageMgr rBuffPageMgr;

    BPTreeRecordsMgr(BPlusTree bpTree, RecordBufferPageMgr rBuffPageMgr) {
        this.bpTree = bpTree;
        this.rBuffPageMgr = rBuffPageMgr;
    }

    public int allocateId() {
        return this.rBuffPageMgr.allocateId();
    }

    public BPTreeRecords get(int id) {
        RecordBufferPage rbp = this.rBuffPageMgr.get(id);
        BPTreeRecords bRec = new BPTreeRecords(this.bpTree, rbp);
        return bRec;
    }

    public BPTreeRecords getSilent(int id) {
        RecordBufferPage rbp = (RecordBufferPage)this.rBuffPageMgr.getSilent(id);
        BPTreeRecords bRec = new BPTreeRecords(this.bpTree, rbp);
        return bRec;
    }

    public void put(BPTreeRecords bRec) {
        this.rBuffPageMgr.put(bRec.getRecordBufferPage());
    }

    public void release(int id) {
        this.rBuffPageMgr.release(id);
    }

    public boolean valid(int id) {
        return this.rBuffPageMgr.valid(id);
    }

    public BPTreeRecords create(int id) {
        RecordBufferPage rbp = this.rBuffPageMgr.create(id);
        BPTreeRecords bRec = new BPTreeRecords(this.bpTree, rbp);
        return bRec;
    }

    public BlockMgr getBlockMgr() {
        return this.rBuffPageMgr.getBlockMgr();
    }

    public void dump() {
        this.rBuffPageMgr.dump();
    }
}

