/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.tdb.base.StorageException;
import com.hp.hpl.jena.tdb.base.buffer.RecordBuffer;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPage;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeException;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreePage;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;
import io.IndentedWriter;
import java.nio.ByteBuffer;
import lib.Lib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BPTreeRecords
extends BPTreePage {
    private static Logger log = LoggerFactory.getLogger(BPTreeRecords.class);
    private final RecordBufferPage rBuffPage;
    private final RecordBuffer rBuff;

    public BPTreeRecords(BPlusTree bpTree, RecordBufferPage rbp) {
        super(bpTree, bpTree.getRecordsMgr().getBlockMgr());
        this.rBuffPage = rbp;
        this.rBuff = this.rBuffPage.getRecordBuffer();
    }

    RecordBufferPage getRecordBufferPage() {
        return this.rBuffPage;
    }

    RecordBuffer getRecordBuffer() {
        return this.rBuff;
    }

    int getLink() {
        return this.rBuffPage.getLink();
    }

    @Override
    boolean isFull() {
        return this.rBuff.size() >= this.rBuff.maxSize();
    }

    @Override
    boolean isMinSize() {
        return this.rBuff.size() <= this.rBuff.maxSize() / 2;
    }

    @Override
    Record internalSearch(Record rec) {
        int i = this.rBuff.find(rec);
        if (i < 0) {
            return null;
        }
        return this.rBuff.get(i);
    }

    @Override
    BPTreeRecords findPage(Record record) {
        if (this.rBuff.size() == 0) {
            return this;
        }
        if (this.getLink() != -1 && Record.keyGT(record, this.maxRecord())) {
            BPTreeRecords.error("Record [%s] not in this page: %s", record, this);
        }
        return this;
    }

    @Override
    BPTreeRecords findFirstPage() {
        return this;
    }

    @Override
    final void put() {
        this.bpTree.getRecordsMgr().put(this);
    }

    @Override
    final void release() {
        this.bpTree.getRecordsMgr().release(this.getId());
    }

    @Override
    Record internalInsert(Record record) {
        int i = this.rBuff.find(record);
        Record r2 = null;
        if (i < 0) {
            i = Lib.decodeIndex(i);
            if (this.rBuff.size() >= this.rBuff.maxSize()) {
                throw new StorageException("RecordBlock.put overflow");
            }
            this.rBuff.add(i, record);
        } else {
            r2 = this.rBuff.get(i);
            if (Record.compareByKeyValue(record, r2) != 0) {
                this.rBuff.set(i, record);
            }
        }
        this.put();
        return r2;
    }

    @Override
    Record internalDelete(Record record) {
        int i = this.rBuff.find(record);
        if (i < 0) {
            return null;
        }
        Record r2 = this.rBuff.get(i);
        this.rBuff.remove(i);
        this.put();
        return r2;
    }

    @Override
    final Record getSplitKey() {
        int splitIdx = this.rBuff.size() / 2 - 1;
        Record r = this.rBuff.get(splitIdx);
        return r;
    }

    @Override
    final BPTreePage split() {
        BPTreeRecords other = this.create(this.rBuffPage.getLink());
        this.rBuffPage.setLink(other.getId());
        int splitIdx = this.rBuff.size() / 2 - 1;
        Record r = this.rBuff.get(splitIdx);
        int moveLen = this.rBuff.size() - (splitIdx + 1);
        this.rBuff.copy(splitIdx + 1, other.getRecordBufferPage().getRecordBuffer(), 0, moveLen);
        this.rBuff.clear(splitIdx + 1, moveLen);
        this.rBuff.setSize(splitIdx + 1);
        if (BPlusTreeParams.CheckingNode && !Record.keyEQ(r, this.maxRecord())) {
            System.err.println(this.rBuff);
            System.err.println(other.rBuff);
            BPTreeRecords.error("BPTreeRecords.split: Not returning expected record", new Object[0]);
        }
        return other;
    }

    private BPTreeRecords create(int linkId) {
        int id = this.bpTree.getRecordsMgr().allocateId();
        BPTreeRecords newPage = this.bpTree.getRecordsMgr().create(id);
        newPage.getRecordBufferPage().setLink(linkId);
        newPage.getRecordBufferPage().setId(id);
        return newPage;
    }

    @Override
    Record shiftRight(BPTreePage other, Record splitKey) {
        BPTreeRecords page = BPTreeRecords.cast(other);
        this.rBuff.shiftRight(page.rBuff);
        if (this.rBuff.size() == 0) {
            return null;
        }
        return this.rBuff.getHigh();
    }

    @Override
    Record shiftLeft(BPTreePage other, Record splitKey) {
        BPTreeRecords page = BPTreeRecords.cast(other);
        this.rBuff.shiftLeft(page.rBuff);
        if (this.rBuff.size() == 0) {
            return null;
        }
        return this.rBuff.getHigh();
    }

    @Override
    BPTreePage merge(BPTreePage right, Record splitKey) {
        return BPTreeRecords.merge(this, BPTreeRecords.cast(right));
    }

    private static BPTreeRecords merge(BPTreeRecords left, BPTreeRecords right) {
        right.rBuff.copyToTop(left.rBuff);
        right.rBuff.clear();
        left.rBuffPage.setLink(right.rBuffPage.getLink());
        return left;
    }

    private static BPTreeRecords cast(BPTreePage page) {
        try {
            return (BPTreeRecords)page;
        }
        catch (ClassCastException ex) {
            BPTreeRecords.error("Wrong type: " + page, new Object[0]);
            return null;
        }
    }

    @Override
    final Record minRecord() {
        return this.getLowRecord();
    }

    @Override
    final Record maxRecord() {
        return this.getHighRecord();
    }

    private static void error(String msg, Object ... args) {
        msg = String.format(msg, args);
        System.out.println(msg);
        System.out.flush();
        throw new BPTreeException(msg);
    }

    @Override
    final Record getLowRecord() {
        if (this.rBuff.size() == 0) {
            return null;
        }
        return this.rBuff.getLow();
    }

    @Override
    final Record getHighRecord() {
        if (this.rBuff.size() == 0) {
            return null;
        }
        return this.rBuff.getHigh();
    }

    @Override
    public final int getMaxSize() {
        return this.rBuff.maxSize();
    }

    @Override
    public final int getCount() {
        return this.rBuff.size();
    }

    @Override
    public final void setCount(int count) {
        this.rBuff.setSize(count);
    }

    public String toString() {
        return String.format("BPTreeRecords[id=%d, link=%d]: %s", this.getId(), this.getLink(), this.rBuff.toString());
    }

    @Override
    public final void checkNode() {
        if (!BPlusTreeParams.CheckingNode) {
            return;
        }
        if (this.rBuff.size() < 0 || this.rBuff.size() > this.rBuff.maxSize()) {
            BPTreeRecords.error("Misized: %s", this);
        }
        for (int i = 1; i < this.getCount(); ++i) {
            Record r2;
            Record r1 = this.rBuff.get(i - 1);
            if (!Record.keyGT(r1, r2 = this.rBuff.get(i))) continue;
            BPTreeRecords.error("Not sorted: %s", this);
        }
    }

    @Override
    public final void checkNodeDeep() {
        this.checkNode();
    }

    @Override
    public ByteBuffer getBackingByteBuffer() {
        return this.rBuffPage.getBackingByteBuffer();
    }

    @Override
    public int getId() {
        return this.rBuffPage.getId();
    }

    @Override
    public void setId(int id) {
        this.rBuffPage.setId(id);
    }

    @Override
    public void output(IndentedWriter out) {
        out.print(this.toString());
    }
}

