/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index.bplustree;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.page.Page;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.index.bplustree.BPTreeRecords;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTree;
import com.hp.hpl.jena.tdb.index.bplustree.BPlusTreeParams;

public abstract class BPTreePage
implements Page {
    protected final BPlusTree bpTree;
    protected final BPlusTreeParams params;
    protected final BlockMgr blockMgr;

    protected BPTreePage(BPlusTree bpTree, BlockMgr blockMgr) {
        if (bpTree == null) {
            System.err.println("NULL B+Tree");
        }
        this.bpTree = bpTree;
        this.params = bpTree.getParams();
        this.blockMgr = blockMgr;
    }

    abstract BPTreePage split();

    abstract Record shiftRight(BPTreePage var1, Record var2);

    abstract Record shiftLeft(BPTreePage var1, Record var2);

    abstract BPTreePage merge(BPTreePage var1, Record var2);

    abstract boolean isFull();

    abstract boolean isMinSize();

    abstract Record internalSearch(Record var1);

    abstract BPTreeRecords findPage(Record var1);

    abstract BPTreeRecords findFirstPage();

    abstract Record internalInsert(Record var1);

    abstract Record internalDelete(Record var1);

    abstract Record getLowRecord();

    abstract Record getHighRecord();

    abstract Record minRecord();

    abstract Record maxRecord();

    abstract void put();

    abstract void release();

    abstract void checkNode();

    abstract void checkNodeDeep();

    abstract Record getSplitKey();
}

