/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index;

import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.index.mem.Index;
import com.hp.hpl.jena.tdb.index.mem.Index3;
import com.hp.hpl.jena.tdb.index.mem.IterFunc;
import com.hp.hpl.jena.tdb.store.NodeId;
import iterator.NullIterator;
import iterator.SingletonIterator;
import java.util.Iterator;
import lib.ColumnMap;
import lib.InternalError;
import lib.Tuple;

public class TupleIndexMem
implements TupleIndex {
    private Index3<NodeId, NodeId, NodeId, Tuple<NodeId>> index = new Index3();
    private ColumnMap colMap;
    private int tupleLength;

    public TupleIndexMem(int N, ColumnMap colMapping) {
        this.tupleLength = N;
        this.colMap = colMapping;
    }

    @Override
    public boolean add(Tuple<NodeId> tuple) {
        NodeId x1 = this.colMap.mapSlot(0, tuple);
        NodeId x2 = this.colMap.mapSlot(1, tuple);
        NodeId x3 = this.colMap.mapSlot(2, tuple);
        return this.index.put(x1, x2, x3, tuple);
    }

    @Override
    public Iterator<Tuple<NodeId>> all() {
        return this.index.flatten();
    }

    @Override
    public boolean delete(Tuple<NodeId> tuple) {
        NodeId x1 = this.colMap.mapSlot(0, tuple);
        NodeId x2 = this.colMap.mapSlot(1, tuple);
        NodeId x3 = this.colMap.mapSlot(2, tuple);
        return this.index.remove(x1, x2, x3);
    }

    @Override
    public Iterator<Tuple<NodeId>> find(Tuple<NodeId> pattern) {
        NodeId x3;
        NodeId x2;
        NodeId x1 = this.colMap.mapSlot(0, pattern);
        if (x1 == NodeId.NodeDoesNotExist) {
            return new NullIterator<Tuple<NodeId>>();
        }
        if (x1 == NodeId.NodeIdAny) {
            x1 = null;
        }
        if ((x2 = this.colMap.mapSlot(1, pattern)) == NodeId.NodeDoesNotExist) {
            return new NullIterator<Tuple<NodeId>>();
        }
        if (x2 == NodeId.NodeIdAny) {
            x2 = null;
        }
        if ((x3 = this.colMap.mapSlot(2, pattern)) == NodeId.NodeDoesNotExist) {
            return new NullIterator<Tuple<NodeId>>();
        }
        if (x3 == NodeId.NodeIdAny) {
            x3 = null;
        }
        if (x1 == null) {
            throw new InternalError("TupleIndexMem.find: no first index");
        }
        if (x2 == null) {
            Index<NodeId, Index<NodeId, Tuple<NodeId>>> idx = this.index.get(x1);
            return IterFunc.flattenII(idx);
        }
        if (x3 == null) {
            Index<NodeId, Tuple<NodeId>> idx = this.index.get(x1, x2);
            return idx.values().iterator();
        }
        Tuple<NodeId> t = this.index.get(x1, x2, x3);
        if (t == null) {
            return new NullIterator<Tuple<NodeId>>();
        }
        return new SingletonIterator<Tuple<NodeId>>(t);
    }

    @Override
    public String getLabel() {
        return this.colMap.getLabel();
    }

    @Override
    public int getTupleLength() {
        return this.tupleLength;
    }

    @Override
    public int weight(Tuple<NodeId> pattern) {
        if (this.undef(pattern.get(0))) {
            return 0;
        }
        if (this.undef(pattern.get(1))) {
            return 1;
        }
        if (this.undef(pattern.get(2))) {
            return 2;
        }
        return 3;
    }

    private boolean undef(NodeId x) {
        return x == null || x == NodeId.NodeIdAny;
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public long size() {
        return this.index.size();
    }

    @Override
    public void sync(boolean force) {
    }

    public void close() {
    }
}

