/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index;

import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.TestTupleIndexRecord;
import com.hp.hpl.jena.tdb.index.TupleIndex;
import com.hp.hpl.jena.tdb.index.TupleIndexRecord;
import com.hp.hpl.jena.tdb.index.TupleTable;
import com.hp.hpl.jena.tdb.store.NodeId;
import iterator.Iter;
import java.util.Iterator;
import java.util.List;
import lib.Tuple;
import org.junit.Test;
import test.BaseTest;

public class TestTupleTable
extends BaseTest {
    static RecordFactory factory = new RecordFactory(24, 0);
    static NodeId n1 = new NodeId(1L);
    static NodeId n2 = new NodeId(2L);
    static NodeId n3 = new NodeId(3L);
    static NodeId n4 = new NodeId(0x4040404040404040L);
    static NodeId n5 = new NodeId(0x5555555555555555L);
    static NodeId n6 = new NodeId(0x6666666666666666L);

    private static TupleTable create() {
        TupleIndexRecord idxSPO = TestTupleIndexRecord.create("SPO");
        TupleIndexRecord idxPOS = TestTupleIndexRecord.create("POS");
        TupleIndexRecord idxOSP = TestTupleIndexRecord.create("OSP");
        TupleIndex[] x = new TupleIndex[]{idxSPO, idxPOS, idxOSP};
        TupleTable table = new TupleTable(3, x);
        return table;
    }

    private static TupleTable create2() {
        TupleIndexRecord idxSPO = TestTupleIndexRecord.create("SPO");
        TupleIndex[] x = new TupleIndex[]{idxSPO};
        TupleTable table = new TupleTable(3, x);
        return table;
    }

    static void add(TupleTable table, NodeId x1, NodeId x2, NodeId x3) {
        Tuple<NodeId> tuple = Tuple.create(x1, x2, x3);
        table.add(tuple);
    }

    @Test
    public void create1() {
        TestTupleTable.create();
    }

    @Test
    public void createFind1() {
        TupleTable table = TestTupleTable.create();
        TestTupleTable.add(table, n1, n2, n3);
        Tuple<NodeId> pat = Tuple.create(null, null, null);
        Iterator<Tuple<NodeId>> iter = table.find(pat);
        List<Tuple<NodeId>> x = Iter.toList(iter);
        int z = x.size();
        TestTupleTable.assertEquals((long)1L, (long)z);
        Tuple<NodeId> e1 = x.get(0);
        TestTupleTable.assertEquals(Tuple.create(n1, n2, n3), e1);
    }

    @Test
    public void createFind2() {
        TupleTable table = TestTupleTable.create();
        TestTupleTable.add(table, n1, n2, n3);
        TestTupleTable.add(table, n1, n2, n4);
        Tuple<NodeId> pat = Tuple.create(null, n2, null);
        Iterator<Tuple<NodeId>> iter = table.find(pat);
        TestTupleTable.assertNotNull(iter);
        List<Tuple<NodeId>> x = Iter.toList(iter);
        int z = x.size();
        TestTupleTable.assertEquals((long)2L, (long)z);
        Tuple<NodeId> e1 = x.get(0);
        Tuple<NodeId> e2 = x.get(1);
        TestTupleTable.assertEquals(Tuple.create(n1, n2, n3), e1);
        TestTupleTable.assertEquals(Tuple.create(n1, n2, n4), e2);
    }

    @Test
    public void createFind3() {
        TupleTable table = TestTupleTable.create2();
        TestTupleTable.add(table, n1, n2, n3);
        TestTupleTable.add(table, n1, n2, n4);
        Tuple<NodeId> pat = Tuple.create(n1, null, n3);
        Iterator<Tuple<NodeId>> iter = table.find(pat);
        TestTupleTable.assertNotNull(iter);
        List<Tuple<NodeId>> x = Iter.toList(iter);
        int z = x.size();
        TestTupleTable.assertEquals((long)1L, (long)z);
        Tuple<NodeId> e1 = x.get(0);
        TestTupleTable.assertEquals(Tuple.create(n1, n2, n3), e1);
    }

    @Test
    public void createFind4() {
        TupleTable table = TestTupleTable.create2();
        TestTupleTable.add(table, n1, n2, n3);
        TestTupleTable.add(table, n1, n2, n4);
        Tuple<NodeId> pat = Tuple.create(null, null, n3);
        Iterator<Tuple<NodeId>> iter = table.find(pat);
        TestTupleTable.assertNotNull(iter);
        List<Tuple<NodeId>> x = Iter.toList(iter);
        int z = x.size();
        TestTupleTable.assertEquals((long)1L, (long)z);
        Tuple<NodeId> e1 = x.get(0);
        TestTupleTable.assertEquals(Tuple.create(n1, n2, n3), e1);
    }

    @Test
    public void createFind5() {
        TupleTable table = TestTupleTable.create2();
        TestTupleTable.add(table, n1, n2, n3);
        TestTupleTable.add(table, n1, n2, n4);
        Tuple<NodeId> pat = Tuple.create(null, NodeId.NodeIdAny, n3);
        Iterator<Tuple<NodeId>> iter = table.find(pat);
        TestTupleTable.assertNotNull(iter);
        List<Tuple<NodeId>> x = Iter.toList(iter);
        int z = x.size();
        TestTupleTable.assertEquals((long)1L, (long)z);
        Tuple<NodeId> e1 = x.get(0);
        TestTupleTable.assertEquals(Tuple.create(n1, n2, n3), e1);
    }
}

