/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index;

import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.IndexBuilder;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.TupleIndexRecord;
import com.hp.hpl.jena.tdb.store.NodeId;
import iterator.Iter;
import java.util.Iterator;
import java.util.Set;
import lib.ColumnMap;
import lib.Tuple;
import org.junit.Test;
import tdb.Cmd;
import test.BaseTest;

public class TestTupleIndexRecord
extends BaseTest {
    static RecordFactory factory;
    static NodeId n1;
    static NodeId n2;
    static NodeId n3;
    static NodeId n4;
    static NodeId n5;
    static NodeId n6;

    static TupleIndexRecord create(String description) {
        RangeIndex rIdx = IndexBuilder.mem().newRangeIndex(null, factory, "TupleIndexTest");
        ColumnMap cmap = new ColumnMap("SPO", description);
        TupleIndexRecord index = new TupleIndexRecord(3, cmap, factory, rIdx);
        return index;
    }

    static void add(TupleIndexRecord index, NodeId x1, NodeId x2, NodeId x3) {
        Tuple<NodeId> tuple = Tuple.create(x1, x2, x3);
        index.add(tuple);
    }

    @Test
    public void TupleIndexRecord_1() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
    }

    @Test
    public void TupleIndexRecordSPO_1() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        Tuple<NodeId> tuple2 = Tuple.create(n1, n2, n3);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        TestTupleIndexRecord.assertTrue((boolean)iter.hasNext());
        iter.next();
        TestTupleIndexRecord.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void TupleIndexRecordSPO_2() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        Tuple<NodeId> tuple2 = Tuple.create(n1, n2, null);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        TestTupleIndexRecord.assertTrue((boolean)iter.hasNext());
        iter.next();
        TestTupleIndexRecord.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void TupleIndexRecordSPO_3() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        Tuple<NodeId> tuple2 = Tuple.create(n1, null, n3);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        TestTupleIndexRecord.assertNull(iter);
        iter = index.findOrPartialScan(tuple2);
        TestTupleIndexRecord.assertTrue((boolean)iter.hasNext());
        iter.next();
        TestTupleIndexRecord.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void TupleIndexRecordSPO_4() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        Tuple<NodeId> tuple2 = Tuple.create(n1, NodeId.NodeIdAny, NodeId.NodeIdAny);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        TestTupleIndexRecord.assertTrue((boolean)iter.hasNext());
        iter.next();
        TestTupleIndexRecord.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void TupleIndexRecordSPO_5() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        TestTupleIndexRecord.add(index, n1, n2, n4);
        Tuple<NodeId> tuple2 = Tuple.create(n1, n2, n3);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        Set<Tuple<NodeId>> x = Iter.toSet(iter);
        TestTupleIndexRecord.assertEquals((long)1L, (long)x.size());
        TestTupleIndexRecord.assertTrue((boolean)x.contains(Tuple.create(n1, n2, n3)));
        TestTupleIndexRecord.assertFalse((boolean)x.contains(Tuple.create(n1, n2, n4)));
    }

    @Test
    public void TupleIndexRecordSPO_6() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        TestTupleIndexRecord.add(index, n1, n2, n4);
        Tuple<NodeId> tuple2 = Tuple.create(n1, n2, NodeId.NodeIdAny);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        Set<Tuple<NodeId>> x = Iter.toSet(iter);
        TestTupleIndexRecord.assertEquals((long)2L, (long)x.size());
        TestTupleIndexRecord.assertTrue((boolean)x.contains(Tuple.create(n1, n2, n3)));
        TestTupleIndexRecord.assertTrue((boolean)x.contains(Tuple.create(n1, n2, n4)));
    }

    @Test
    public void TupleIndexRecordSPO_7() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        TestTupleIndexRecord.add(index, n1, n2, n4);
        Tuple<NodeId> tuple2 = Tuple.create(n1, NodeId.NodeIdAny, NodeId.NodeIdAny);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        Set<Tuple<NodeId>> x = Iter.toSet(iter);
        TestTupleIndexRecord.assertEquals((long)2L, (long)x.size());
        TestTupleIndexRecord.assertTrue((boolean)x.contains(Tuple.create(n1, n2, n3)));
        TestTupleIndexRecord.assertTrue((boolean)x.contains(Tuple.create(n1, n2, n4)));
    }

    @Test
    public void TupleIndexRecordSPO_8() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        TestTupleIndexRecord.add(index, n2, n3, n4);
        Tuple<NodeId> tuple2 = Tuple.create(n1, NodeId.NodeIdAny, NodeId.NodeIdAny);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        Set<Tuple<NodeId>> x = Iter.toSet(iter);
        TestTupleIndexRecord.assertEquals((long)1L, (long)x.size());
        TestTupleIndexRecord.assertTrue((boolean)x.contains(Tuple.create(n1, n2, n3)));
        tuple2 = Tuple.create(n2, NodeId.NodeIdAny, NodeId.NodeIdAny);
        iter = index.findByIndex(tuple2);
        x = Iter.toSet(iter);
        TestTupleIndexRecord.assertEquals((long)1L, (long)x.size());
        TestTupleIndexRecord.assertTrue((boolean)x.contains(Tuple.create(n2, n3, n4)));
    }

    @Test
    public void TupleIndexRecordPOS_1() {
        TupleIndexRecord index = TestTupleIndexRecord.create("POS");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        Tuple<NodeId> tuple2 = Tuple.create(n1, n2, n3);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        TestTupleIndexRecord.assertTrue((String)"Can't find tuple", (boolean)iter.hasNext());
        iter.next();
        TestTupleIndexRecord.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void TupleIndexRecordPOS_2() {
        TupleIndexRecord index = TestTupleIndexRecord.create("POS");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        Tuple<NodeId> tuple2 = Tuple.create(null, n2, null);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        TestTupleIndexRecord.assertTrue((String)"Can't find tuple", (boolean)iter.hasNext());
        iter.next();
        TestTupleIndexRecord.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void TupleIndexRecordPOS_3() {
        TupleIndexRecord index = TestTupleIndexRecord.create("POS");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        Tuple<NodeId> tuple2 = Tuple.create(null, n2, n3);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        TestTupleIndexRecord.assertTrue((String)"Can't find tuple", (boolean)iter.hasNext());
        iter.next();
        TestTupleIndexRecord.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void TupleIndexRecordFindScan_1() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        Tuple<NodeId> tuple2 = Tuple.create(n1, null, n3);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        TestTupleIndexRecord.assertNull(iter);
        iter = index.findOrPartialScan(tuple2);
        TestTupleIndexRecord.assertTrue((boolean)iter.hasNext());
        iter.next();
        TestTupleIndexRecord.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void TupleIndexRecordFindScan_2() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        TestTupleIndexRecord.add(index, n1, n2, n4);
        Tuple<NodeId> tuple2 = Tuple.create(null, null, n3);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        TestTupleIndexRecord.assertNull(iter);
        iter = index.findOrPartialScan(tuple2);
        TestTupleIndexRecord.assertNull(iter);
        iter = index.findOrScan(tuple2);
        TestTupleIndexRecord.assertTrue((boolean)iter.hasNext());
        iter.next();
        TestTupleIndexRecord.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void TupleIndexRecordFindNot_1() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        Tuple<NodeId> tuple2 = Tuple.create(n4, n5, n6);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        TestTupleIndexRecord.assertNotNull(iter);
        TestTupleIndexRecord.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void TupleIndexRecordFindNot_2() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        Tuple<NodeId> tuple2 = Tuple.create(n1, n5, n6);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        TestTupleIndexRecord.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void TupleIndexRecordFindNot_3() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        Tuple<NodeId> tuple2 = Tuple.create(n1, null, n6);
        Iterator<Tuple<NodeId>> iter = index.findOrPartialScan(tuple2);
        TestTupleIndexRecord.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void TupleIndexRecordFindNot_4() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        TestTupleIndexRecord.add(index, n1, n5, n6);
        Tuple<NodeId> tuple2 = Tuple.create(n4, n5, n6);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        TestTupleIndexRecord.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void TupleIndexRecordFindNot_5() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        TestTupleIndexRecord.add(index, n1, n5, n6);
        Tuple<NodeId> tuple2 = Tuple.create(n2, n5, n6);
        Iterator<Tuple<NodeId>> iter = index.findByIndex(tuple2);
        TestTupleIndexRecord.assertFalse((boolean)iter.hasNext());
    }

    @Test
    public void TupleIndexRecordFindNot_6() {
        TupleIndexRecord index = TestTupleIndexRecord.create("SPO");
        TestTupleIndexRecord.add(index, n1, n2, n3);
        TestTupleIndexRecord.add(index, n4, n5, n6);
        Tuple<NodeId> tuple2 = Tuple.create(n1, null, n6);
        Iterator<Tuple<NodeId>> iter = index.findOrPartialScan(tuple2);
        TestTupleIndexRecord.assertFalse((boolean)iter.hasNext());
    }

    static {
        Cmd.setLog4j();
        factory = new RecordFactory(24, 0);
        n1 = new NodeId(1L);
        n2 = new NodeId(2L);
        n3 = new NodeId(3L);
        n4 = new NodeId(0x4040404040404040L);
        n5 = new NodeId(0x5555555555555555L);
        n6 = new NodeId(0x6666666666666666L);
    }
}

