/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index;

import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordLib;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexTestLib;
import org.junit.After;
import org.junit.Test;
import test.BaseTest;

public abstract class TestIndex
extends BaseTest {
    Index index = null;

    @After
    public void afterTest() {
        if (this.index != null) {
            this.index.close();
        }
        this.index = null;
    }

    protected abstract Index makeIndex();

    @Test
    public void index_ins_0() {
        int[] keys = new int[]{};
        this.test(keys);
    }

    @Test
    public void index_ins_1() {
        int[] keys = new int[]{1};
        this.test(keys);
    }

    @Test
    public void index_ins_2() {
        int[] keys = new int[20];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = i;
        }
        this.test(keys);
    }

    @Test
    public void index_ins_3() {
        int[] keys = new int[20];
        for (int i = keys.length - 1; i >= 0; --i) {
            keys[i] = i;
        }
        this.test(keys);
    }

    @Test
    public void index_ins_4() {
        int[] keys = new int[10];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = 1 << i;
        }
        this.test(keys);
    }

    @Test
    public void index_ins_5() {
        int[] keys = new int[10];
        for (int i = keys.length - 1; i >= 0; --i) {
            keys[i] = 1 << i;
        }
        this.test(keys);
    }

    @Test
    public void index_find_1() {
        int[] keys = new int[]{1};
        Index index = this.test(keys);
        Record r = RecordLib.intToRecord(1, 4);
        r = index.find(r);
        TestIndex.assertNotNull((Object)r);
    }

    @Test
    public void index_find_2() {
        int[] keys = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        Index index = this.test(keys);
        Record r = RecordLib.intToRecord(20, 4);
        r = index.find(r);
        TestIndex.assertNull((Object)r);
    }

    @Test
    public void index_del_1() {
        int[] keys1 = new int[]{0, 1, 2};
        int[] keys2 = new int[]{0, 1, 2};
        int[] keys3 = new int[]{};
        this.test(keys1, keys2, keys3);
    }

    @Test
    public void index_del_2() {
        int[] keys1 = new int[]{0, 1, 2};
        int[] keys2 = new int[]{0, 1};
        int[] keys3 = new int[]{2};
        this.test(keys1, keys2, keys3);
    }

    @Test
    public void index_del_3() {
        int[] keys1 = new int[]{0, 1, 2};
        int[] keys2 = new int[]{0, 99};
        int[] keys3 = new int[]{2, 1};
        this.test(keys1, keys2, keys3);
    }

    private Index test(int[] insKeys, int[] delKeys, int[] expected) {
        this.index = this.makeIndex();
        IndexTestLib.testInsert(this.index, insKeys);
        long x = this.index.size();
        if (x >= 0L) {
            TestIndex.assertEquals((long)insKeys.length, (long)x);
        }
        if (delKeys != null) {
            IndexTestLib.testDelete(this.index, delKeys);
        }
        if (expected != null) {
            IndexTestLib.testIndexContents(this.index, expected);
        }
        return this.index;
    }

    private Index test(int[] keys) {
        return this.test(keys, null, keys);
    }
}

