/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.index;

import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.Index;
import com.hp.hpl.jena.tdb.index.IndexFactory;
import com.hp.hpl.jena.tdb.index.IndexRangeFactory;
import com.hp.hpl.jena.tdb.index.IndexType;
import com.hp.hpl.jena.tdb.index.RangeIndex;
import com.hp.hpl.jena.tdb.index.factories.IndexFactoryBPlusTree;
import com.hp.hpl.jena.tdb.index.factories.IndexFactoryBPlusTreeMem;
import com.hp.hpl.jena.tdb.index.factories.IndexFactoryBTree;
import com.hp.hpl.jena.tdb.index.factories.IndexFactoryBTreeMem;
import com.hp.hpl.jena.tdb.index.factories.IndexFactoryExtHash;
import com.hp.hpl.jena.tdb.index.factories.IndexFactoryExtHashMem;
import com.hp.hpl.jena.tdb.sys.SystemTDB;

public class IndexBuilder {
    private static IndexBuilder builder = IndexBuilder.chooseIndexBuilder();
    private static IndexBuilder builderMem = null;
    IndexFactory factoryIndex = null;
    IndexRangeFactory builderRangeIndex = null;

    public static IndexBuilder get() {
        return builder;
    }

    public static IndexBuilder getBTree() {
        return IndexBuilder.createIndexBuilder(IndexType.BTree);
    }

    public static IndexBuilder getBPlusTree() {
        return IndexBuilder.createIndexBuilder(IndexType.BPlusTree);
    }

    public static IndexBuilder getExtHash() {
        return IndexBuilder.createIndexBuilder(IndexType.ExtHash);
    }

    public static IndexBuilder mem() {
        return IndexBuilder.createIndexBuilderMem(SystemTDB.getIndexType());
    }

    private static synchronized IndexBuilder chooseIndexBuilder() {
        return IndexBuilder.createIndexBuilder(SystemTDB.getIndexType());
    }

    private static IndexBuilder createIndexBuilderMem(IndexType indexType) {
        switch (indexType) {
            case BTree: {
                IndexFactoryBTreeMem idxFactory = new IndexFactoryBTreeMem(5);
                return new IndexBuilder(idxFactory, idxFactory);
            }
            case BPlusTree: {
                IndexFactoryBPlusTreeMem idxFactory = new IndexFactoryBPlusTreeMem(5);
                return new IndexBuilder(idxFactory, idxFactory);
            }
            case ExtHash: {
                IndexFactoryExtHashMem idxFactory = new IndexFactoryExtHashMem();
                IndexFactoryBPlusTreeMem idxRangeFactory = new IndexFactoryBPlusTreeMem(5);
                return new IndexBuilder(idxFactory, idxRangeFactory);
            }
        }
        throw new TDBException("Memory index builder: Unrecognized index type: " + (Object)((Object)indexType));
    }

    private static IndexBuilder createIndexBuilder(IndexType indexType) {
        switch (indexType) {
            case BTree: {
                IndexFactoryBTree idx = new IndexFactoryBTree(8192);
                return new IndexBuilder(idx, idx);
            }
            case BPlusTree: {
                IndexFactoryBPlusTree idx = new IndexFactoryBPlusTree(8192);
                return new IndexBuilder(idx, idx);
            }
            case ExtHash: {
                IndexFactoryExtHash idxFactory = new IndexFactoryExtHash(8192);
                IndexFactoryBPlusTree idx = new IndexFactoryBPlusTree(8192);
                return new IndexBuilder(idxFactory, idx);
            }
        }
        throw new TDBException("Unrecognized index type: " + (Object)((Object)indexType));
    }

    public static Index createIndex(Location location, String name, RecordFactory recordFactory) {
        return builder.newIndex(location, recordFactory, name);
    }

    public static RangeIndex createRangeIndex(Location location, String name, RecordFactory recordFactory) {
        return builder.newRangeIndex(location, recordFactory, name);
    }

    public IndexBuilder(IndexFactory indexBuilder, IndexRangeFactory rangeIndexBuilder) {
        this.factoryIndex = indexBuilder;
        this.builderRangeIndex = rangeIndexBuilder;
    }

    public Index newIndex(Location location, RecordFactory factory, String name) {
        return this.factoryIndex.createIndex(location, name, factory);
    }

    public RangeIndex newRangeIndex(Location location, RecordFactory factory, String name) {
        return this.builderRangeIndex.createRangeIndex(location, name, factory);
    }
}

