/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.graph;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.graph.TestPrefixMapping2;
import com.hp.hpl.jena.tdb.store.DatasetPrefixes;
import lib.FileOps;
import org.junit.Test;

public class TestPrefixMappingTDB
extends TestPrefixMapping2 {
    static DatasetPrefixes datasetPrefixes = DatasetPrefixes.testing();

    @Override
    protected PrefixMapping create() {
        return datasetPrefixes.getPrefixMapping();
    }

    @Test
    public void multiple1() {
        DatasetPrefixes prefixes = DatasetPrefixes.testing();
        PrefixMapping pmap1 = prefixes.getPrefixMapping();
        PrefixMapping pmap2 = prefixes.getPrefixMapping("http://graph/");
        pmap1.setNsPrefix("x", "http://foo/");
        TestPrefixMappingTDB.assertNull((Object)pmap2.getNsPrefixURI("x"));
        TestPrefixMappingTDB.assertNotNull((Object)pmap1.getNsPrefixURI("x"));
    }

    @Test
    public void multiple2() {
        DatasetPrefixes prefixes = DatasetPrefixes.testing();
        PrefixMapping pmap1 = prefixes.getPrefixMapping("http://graph/");
        PrefixMapping pmap2 = prefixes.getPrefixMapping("http://graph/");
        pmap1.setNsPrefix("x", "http://foo/");
        TestPrefixMappingTDB.assertNotNull((Object)pmap2.getNsPrefixURI("x"));
        TestPrefixMappingTDB.assertNotNull((Object)pmap1.getNsPrefixURI("x"));
    }

    @Test
    public void persistent1() {
        FileOps.clearDirectory("tmp/testing");
        DatasetPrefixes prefixes = new DatasetPrefixes(new Location("tmp/testing"));
        PrefixMapping pmap1 = prefixes.getPrefixMapping();
        pmap1.setNsPrefix("x", "http://foo/");
        prefixes.close();
        prefixes = new DatasetPrefixes(new Location("tmp/testing"));
        TestPrefixMappingTDB.assertEquals((Object)"http://foo/", (Object)pmap1.getNsPrefixURI("x"));
    }
}

