/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.tdb.TDBFactory;
import org.junit.Test;
import test.BaseTest;

public class TestBulkUpdateTDB
extends BaseTest {
    private static String graphName = "http://graph/";
    private static Node n0 = SSE.parseNode((String)"<http://example/n0>");
    private static Node n1 = SSE.parseNode((String)"<http://example/n1>");
    private static Node n2 = SSE.parseNode((String)"<http://example/n2>");
    private static Triple t1 = SSE.parseTriple((String)"(<x> <y> <z>)");

    private static Graph create() {
        Graph g = TDBFactory.createGraph();
        return g;
    }

    @Test
    public void update1() {
        Graph g = TestBulkUpdateTDB.create();
        g.getBulkUpdateHandler().add(new Triple[]{t1});
        TestBulkUpdateTDB.assertTrue((boolean)g.contains(t1));
        g.getBulkUpdateHandler().delete(new Triple[]{t1});
        TestBulkUpdateTDB.assertFalse((boolean)g.contains(t1));
    }

    @Test
    public void update2() {
        Graph g = TestBulkUpdateTDB.create();
        g.getBulkUpdateHandler().add(new Triple[]{t1});
        TestBulkUpdateTDB.assertTrue((boolean)g.contains(t1));
        g.getBulkUpdateHandler().removeAll();
        TestBulkUpdateTDB.assertFalse((boolean)g.contains(t1));
    }

    @Test
    public void update3() {
        Dataset ds = TDBFactory.createDataset();
        ds.asDatasetGraph().getDefaultGraph().add(t1);
        ds.getNamedModel(graphName).getGraph().add(t1);
        Model m = ds.getDefaultModel();
        m.removeAll();
        TestBulkUpdateTDB.assertEquals((long)0L, (long)m.size());
        TestBulkUpdateTDB.assertTrue((boolean)ds.getNamedModel(graphName).getGraph().contains(t1));
    }

    @Test
    public void update4() {
        Dataset ds = TDBFactory.createDataset();
        ds.asDatasetGraph().getDefaultGraph().add(t1);
        ds.getNamedModel(graphName).getGraph().add(t1);
        Model m = ds.getNamedModel(graphName);
        m.removeAll();
        TestBulkUpdateTDB.assertEquals((long)0L, (long)m.size());
        TestBulkUpdateTDB.assertTrue((boolean)ds.getDefaultModel().getGraph().contains(t1));
    }
}

