/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.graph;

import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.core.Closeable;
import com.hp.hpl.jena.tdb.lib.Sync;

public abstract class PrefixMappingPersistent
extends PrefixMappingImpl
implements Closeable,
Sync {
    private String graphName;

    public PrefixMappingPersistent(String graphURI) {
        this.graphName = graphURI;
        try {
            this.readPrefixMapping(this.graphName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void set(String prefix, String uri) {
        super.set(prefix, uri);
        this.insertIntoPrefixMap(this.graphName, prefix, uri);
    }

    protected String get(String prefix) {
        String x = super.get(prefix);
        if (x != null) {
            return x;
        }
        return this.readFromPrefixMap(this.graphName, prefix);
    }

    public PrefixMapping removeNsPrefix(String prefix) {
        String uri = super.getNsPrefixURI(prefix);
        if (uri != null) {
            this.removeFromPrefixMap(this.graphName, prefix, uri);
        }
        super.removeNsPrefix(prefix);
        return this;
    }

    protected abstract void readPrefixMapping(String var1);

    protected abstract String readFromPrefixMap(String var1, String var2);

    protected abstract void insertIntoPrefixMap(String var1, String var2, String var3);

    protected abstract void removeFromPrefixMap(String var1, String var2, String var3);

    private String encode(String prefix) {
        return prefix + ":";
    }

    private String decode(String prefix) {
        return prefix.substring(0, prefix.length() - 1);
    }
}

