/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.recordfile;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFactory;
import com.hp.hpl.jena.tdb.base.buffer.RecordBuffer;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPage;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPageMgr;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import org.junit.BeforeClass;
import org.junit.Test;
import test.BaseTest;

public class TestRecordBufferPage
extends BaseTest {
    static final int TestRecordSize = 2;
    static final int TestNumRecord = 3;
    static RecordFactory factory = new RecordFactory(2, 0);

    @BeforeClass
    public static void before() {
        SystemTDB.NullOut = true;
    }

    @Test
    public void recBufferPage01() {
        BlockMgr blkMgr = TestRecordBufferPage.makeBlockMgr();
        RecordBufferPageMgr rpm = new RecordBufferPageMgr(factory, blkMgr);
        int x = rpm.allocateId();
        RecordBufferPage page = rpm.create(x);
        TestRecordBufferPage.fill(page.getRecordBuffer(), 10, 20, 30);
        TestRecordBufferPage.assertEquals((long)10L, (long)TestRecordBufferPage.get(page, 0));
        TestRecordBufferPage.assertEquals((long)20L, (long)TestRecordBufferPage.get(page, 1));
        TestRecordBufferPage.assertEquals((long)30L, (long)TestRecordBufferPage.get(page, 2));
    }

    @Test
    public void recBufferPage02() {
        BlockMgr blkMgr = TestRecordBufferPage.makeBlockMgr();
        RecordBufferPageMgr rpm = new RecordBufferPageMgr(factory, blkMgr);
        int x = rpm.allocateId();
        RecordBufferPage page1 = rpm.create(x);
        TestRecordBufferPage.fill(page1.getRecordBuffer(), 10, 20, 30);
        rpm.put(page1);
        page1 = null;
        RecordBufferPage page2 = rpm.get(x);
        TestRecordBufferPage.assertEquals((long)10L, (long)TestRecordBufferPage.get(page2, 0));
        TestRecordBufferPage.assertEquals((long)20L, (long)TestRecordBufferPage.get(page2, 1));
        TestRecordBufferPage.assertEquals((long)30L, (long)TestRecordBufferPage.get(page2, 2));
    }

    private static void fill(RecordBuffer rb, int ... nums) {
        for (int i = 0; i < nums.length; ++i) {
            Record rec = TestRecordBufferPage.record(nums[i]);
            rb.add(rec);
        }
    }

    private static int get(RecordBufferPage rbp, int idx) {
        return TestRecordBufferPage.get(rbp.getRecordBuffer(), idx);
    }

    private static int get(RecordBuffer rb, int idx) {
        Record r = rb.get(idx);
        int v = r.getKey()[0] << 8 | r.getKey()[1] & 0xFF;
        return v;
    }

    private static Record record(int i) {
        byte[] b = new byte[]{(byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        Record r = factory.create(b);
        return r;
    }

    private static BlockMgr makeBlockMgr() {
        return BlockMgrFactory.createMem("RecordBuffer", RecordBufferPage.calcBlockSize(factory, 3));
    }
}

