/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.recordfile;

import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPageBase;
import com.hp.hpl.jena.tdb.base.recordfile.RecordBufferPageMgr;
import java.nio.ByteBuffer;

public class RecordBufferPage
extends RecordBufferPageBase {
    public static final int LINK = 4;
    private static final int FIELD_LENGTH = 4;
    private RecordBufferPageMgr pageMgr;
    private int link;

    public int getLink() {
        return this.link;
    }

    public void setLink(int link) {
        this.link = link;
        this.getBackingByteBuffer().putInt(4, link);
    }

    public static int calcRecordSize(RecordFactory factory, int blkSize) {
        return RecordBufferPageBase.calcRecordSize(factory, blkSize, 4);
    }

    public static int calcBlockSize(RecordFactory factory, int maxRec) {
        return RecordBufferPageBase.calcBlockSize(factory, maxRec, 4);
    }

    RecordBufferPage(int id, int linkId, ByteBuffer byteBuffer, RecordFactory factory, RecordBufferPageMgr recordBufferPageMgr, int count) {
        super(id, 4, byteBuffer, factory, count);
        this.pageMgr = recordBufferPageMgr;
        this.link = linkId;
    }

    public final RecordBufferPageMgr getPageMgr() {
        return this.pageMgr;
    }

    public void setPageMgr(RecordBufferPageMgr recordBufferPageMgr) {
        this.pageMgr = recordBufferPageMgr;
    }

    @Override
    public String toString() {
        return String.format("RecordBufferPage[id=%d,link=%d]: %s", this.getId(), this.getLink(), this.recBuff);
    }
}

