/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.record;

import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import iterator.Iter;
import iterator.Transform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lib.Bytes;

public class RecordLib {
    public static final int TestRecordLength = 4;
    public static final RecordFactory recordFactory = new RecordFactory(4, 0);

    public static Record intToRecord(int v) {
        return RecordLib.intToRecord(v, recordFactory);
    }

    public static Record intToRecord(int v, int recLen) {
        return RecordLib.intToRecord(v, new RecordFactory(recLen, 0));
    }

    static Record intToRecord(int v, RecordFactory factory) {
        byte[] vb = Bytes.packInt(v);
        int recLen = factory.recordLength();
        byte[] bb = new byte[recLen];
        int x = 0;
        if (recLen > 4) {
            x = recLen - 4;
        }
        int len = Math.min(4, recLen);
        int z = 4 - len;
        for (int i = len - 1; i >= 0; --i) {
            bb[x + i] = vb[z + i];
        }
        return factory.create(bb);
    }

    public static List<Record> intToRecord(int[] v) {
        return RecordLib.intToRecord(v, recordFactory);
    }

    public static List<Record> intToRecord(int[] v, int recLen) {
        return RecordLib.intToRecord(v, new RecordFactory(recLen, 0));
    }

    static List<Record> intToRecord(int[] v, RecordFactory factory) {
        ArrayList<Record> x = new ArrayList<Record>();
        for (int i : v) {
            x.add(RecordLib.intToRecord(i, factory));
        }
        return x;
    }

    public static int recordToInt(Record key) {
        return Bytes.getInt(key.getKey());
    }

    public static List<Integer> toIntList(Iterator<Record> iter) {
        return Iter.toList(Iter.map(iter, new Transform<Record, Integer>(){

            @Override
            public Integer convert(Record item) {
                return RecordLib.recordToInt(item);
            }
        }));
    }

    public static Record r(int v) {
        return RecordLib.intToRecord(v, 4);
    }

    public static int r(Record rec) {
        return RecordLib.recordToInt(rec);
    }

    public static List<Integer> toIntList(int ... vals) {
        ArrayList<Integer> x = new ArrayList<Integer>();
        for (int i : vals) {
            x.add(i);
        }
        return x;
    }

    public static List<Integer> r(Iterator<Record> iter) {
        return RecordLib.toIntList(iter);
    }
}

