/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.record;

import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordException;
import java.nio.ByteBuffer;

public final class RecordFactory {
    private final int keyLength;
    private final int valueLength;
    private final int slotLen;

    public RecordFactory(int keyLength, int valueLength) {
        this.keyLength = keyLength;
        this.valueLength = valueLength;
        this.slotLen = keyLength + (valueLength > 0 ? valueLength : 0);
    }

    public RecordFactory keyFactory() {
        return new RecordFactory(this.keyLength, 0);
    }

    public Record createKeyOnly() {
        return this.create(new byte[this.keyLength], null);
    }

    public Record createKeyOnly(Record record) {
        this.checkKey(record.getKey());
        if (record.getValue() == null) {
            return record;
        }
        return this.create(record.getKey(), null);
    }

    public Record create(byte[] key) {
        this.checkKey(key);
        byte[] v = null;
        if (this.valueLength > 0) {
            v = new byte[this.valueLength];
        }
        return this.create(key, v);
    }

    public Record create() {
        return this.create(new byte[this.keyLength], this.valueLength > 0 ? new byte[this.valueLength] : null);
    }

    public Record create(byte[] key, byte[] value) {
        this.check(key, value);
        return new Record(key, value);
    }

    public void insertInto(Record record, ByteBuffer bb, int idx) {
        this.check(record);
        bb.position(idx * this.slotLen);
        bb.put(record.getKey(), 0, this.keyLength);
        if (this.hasValue() && record.getValue() != null) {
            bb.put(record.getValue(), 0, this.valueLength);
        }
    }

    public Record buildFrom(ByteBuffer bb, int idx) {
        byte[] key = new byte[this.keyLength];
        byte[] value = this.hasValue() ? new byte[this.valueLength] : null;
        bb.position(idx * this.slotLen);
        bb.get(key, 0, this.keyLength);
        if (value != null) {
            bb.get(value, 0, this.valueLength);
        }
        return this.create(key, value);
    }

    public boolean hasValue() {
        return this.valueLength > 0;
    }

    public int recordLength() {
        return this.keyLength + this.valueLength;
    }

    public int keyLength() {
        return this.keyLength;
    }

    public int valueLength() {
        return this.valueLength;
    }

    public String toString() {
        return String.format("<RecordFactory k=%d v=%d>", this.keyLength, this.valueLength);
    }

    private final void check(Record record) {
        this.check(record.getKey(), record.getValue());
    }

    private final void checkKey(byte[] k) {
        if (k == null) {
            throw new RecordException("Null key byte[]");
        }
        if (this.keyLength != k.length) {
            throw new RecordException(String.format("Key length error: This RecordFactory manages records of key length %d, not %d", this.keyLength, k.length));
        }
    }

    private final void check(byte[] k, byte[] v) {
        this.checkKey(k);
        if (this.valueLength <= 0) {
            if (v != null) {
                throw new RecordException("Value array error: This RecordFactory manages records that are all key");
            }
        } else if (v != null && v.length != this.valueLength) {
            throw new RecordException(String.format("This RecordFactory manages record of value length %d, not (%d,-)", this.valueLength, v.length));
        }
    }
}

