/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.reader;

import com.hp.hpl.jena.tdb.base.reader.PeekReader;
import org.junit.Test;
import test.BaseTest;

public class TestPeekReader
extends BaseTest {
    @Test
    public void read1() {
        PeekReader r = this.make("");
        int x = r.peekChar();
        TestPeekReader.assertEquals((long)-1L, (long)x);
        x = r.readChar();
        TestPeekReader.assertEquals((long)-1L, (long)x);
        x = r.readChar();
        TestPeekReader.assertEquals((long)-1L, (long)x);
    }

    @Test
    public void read2() {
        PeekReader r = this.make("a");
        int x = r.peekChar();
        TestPeekReader.assertEquals((long)97L, (long)x);
        TestPeekReader.assertEquals((long)1L, (long)r.getColNum());
        x = r.readChar();
        TestPeekReader.assertEquals((long)97L, (long)x);
        x = r.peekChar();
        TestPeekReader.assertEquals((long)-1L, (long)x);
        x = r.readChar();
        TestPeekReader.assertEquals((long)-1L, (long)x);
    }

    @Test
    public void read3() {
        String c = "abcde";
        PeekReader r = this.make(c);
        for (int i = 0; i < c.length(); ++i) {
            TestPeekReader.assertEquals((long)(i + 1), (long)r.getColNum());
            TestPeekReader.assertEquals((long)c.charAt(i), (long)r.readChar());
        }
        TestPeekReader.assertTrue((boolean)r.eof());
    }

    @Test
    public void read4() {
        this.position("abcde");
    }

    @Test
    public void read5() {
        this.position("abc\nde");
    }

    @Test
    public void read6() {
        this.position("abc\nde\n");
    }

    private void position(String contents) {
        PeekReader r = this.make(contents);
        int line = 1;
        int col = 1;
        TestPeekReader.assertEquals((long)line, (long)r.getLineNum());
        for (int i = 0; i < contents.length(); ++i) {
            TestPeekReader.assertEquals((long)line, (long)r.getLineNum());
            TestPeekReader.assertEquals((long)col, (long)r.getColNum());
            int x = r.readChar();
            TestPeekReader.assertEquals((long)contents.charAt(i), (long)x);
            if (x == 10) {
                ++line;
                col = 1;
                continue;
            }
            ++col;
        }
        TestPeekReader.assertTrue((boolean)r.eof());
    }

    private PeekReader make(String contents) {
        return this.make(contents, 2);
    }

    private PeekReader make(String contents, int size) {
        return PeekReader.make(contents, size);
    }
}

