/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.reader;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.tdb.base.reader.NodeTupleReader;
import java.io.Reader;
import java.io.StringReader;
import lib.Tuple;
import org.junit.Test;
import test.BaseTest;

public class TestNTriples
extends BaseTest {
    @Test
    public void iri_1() {
        Node x = this.readNode("<x>");
        TestNTriples.assertEquals((Object)Node.createURI((String)"x"), (Object)x);
    }

    @Test
    public void iri_2() {
        Node x = this.readNode("<http://example/x>");
        TestNTriples.assertEquals((Object)Node.createURI((String)"http://example/x"), (Object)x);
    }

    @Test
    public void blank_1() {
        Node x = this.readNode("_:a");
        TestNTriples.assertTrue((boolean)x.isBlank());
    }

    @Test
    public void blank_2() {
        Node x1 = this.readNode("_:a");
        Node x2 = this.readNode("_:b");
        TestNTriples.assertNotEquals(x1, x2);
    }

    @Test
    public void blank_3() {
        Node x1 = this.readNode("_:a");
        Node x2 = this.readNode("_:a");
        TestNTriples.assertEquals((Object)x1, (Object)x2);
    }

    @Test
    public void literal_1() {
        Node x = this.readNode("\"\"");
        TestNTriples.assertEquals((Object)Node.createLiteral((String)""), (Object)x);
    }

    @Test
    public void literal_2() {
        Node x = this.readNode("\"abc\"");
        TestNTriples.assertEquals((Object)Node.createLiteral((String)"abc"), (Object)x);
    }

    @Test
    public void literal_3() {
        Node x = this.readNode("\"abc\"@en");
        TestNTriples.assertEquals((Object)Node.createLiteral((String)"abc", (String)"en", null), (Object)x);
    }

    @Test
    public void literal_4() {
        Node x = this.readNode("\"abc\"@en-uk");
        TestNTriples.assertEquals((Object)Node.createLiteral((String)"abc", (String)"en-uk", null), (Object)x);
    }

    @Test
    public void literal_5() {
        Node x = this.readNode("\"\"@en");
        TestNTriples.assertEquals((Object)Node.createLiteral((String)"", (String)"en", null), (Object)x);
    }

    @Test
    public void literal_6() {
        Node x = this.readNode("\"abc\"^^<http://example/foo>\"");
        RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName("http://example/foo");
        TestNTriples.assertEquals((Object)Node.createLiteral((String)"abc", null, (RDFDatatype)dt), (Object)x);
    }

    @Test
    public void triple_1() {
        Triple x = this.readTriple("<s> <p> <o> .");
        Node s = Node.createURI((String)"s");
        Node p = Node.createURI((String)"p");
        Node o = Node.createURI((String)"o");
        TestNTriples.assertEquals((Object)new Triple(s, p, o), (Object)x);
    }

    @Test
    public void triple_2() {
        Triple x = this.readTriple("<s> <p> \"abc\" .");
        Node s = Node.createURI((String)"s");
        Node p = Node.createURI((String)"p");
        Node o = Node.createLiteral((String)"abc");
        TestNTriples.assertEquals((Object)new Triple(s, p, o), (Object)x);
    }

    @Test
    public void triple_3() {
        Triple x = this.readTriple("<s> <p> <o> . #comment");
        Node s = Node.createURI((String)"s");
        Node p = Node.createURI((String)"p");
        Node o = Node.createURI((String)"o");
        TestNTriples.assertEquals((Object)new Triple(s, p, o), (Object)x);
    }

    @Test
    public void triple_4() {
        Triple x = this.readTriple("  <s><p><o>.");
        Node s = Node.createURI((String)"s");
        Node p = Node.createURI((String)"p");
        Node o = Node.createURI((String)"o");
        TestNTriples.assertEquals((Object)new Triple(s, p, o), (Object)x);
    }

    @Test
    public void triple_5() {
        Triple x = this.readTriple("#comment");
        TestNTriples.assertNull((Object)x);
    }

    @Test
    public void triple_6() {
        Triple x = this.readTriple("  #comment");
        TestNTriples.assertNull((Object)x);
    }

    @Test
    public void esc_1() {
        Triple x = this.readTriple("<s> <p> \"X\\u0020Y\" .");
        TestNTriples.assertNotNull((Object)x);
        Node s = Node.createURI((String)"s");
        Node p = Node.createURI((String)"p");
        Node o = Node.createLiteral((String)"X Y");
        TestNTriples.assertEquals((Object)new Triple(s, p, o), (Object)x);
    }

    @Test
    public void esc_2() {
        Triple x = this.readTriple("<s> <p> \"X\\U00000020Y\" .");
        TestNTriples.assertNotNull((Object)x);
        Node s = Node.createURI((String)"s");
        Node p = Node.createURI((String)"p");
        Node o = Node.createLiteral((String)"X Y");
        TestNTriples.assertEquals((Object)new Triple(s, p, o), (Object)x);
    }

    @Test
    public void esc_3() {
        Triple x = this.readTriple("<s> <p> \"a\\tb\" .");
        TestNTriples.assertNotNull((Object)x);
        Node s = Node.createURI((String)"s");
        Node p = Node.createURI((String)"p");
        Node o = Node.createLiteral((String)"a\tb");
        TestNTriples.assertEquals((Object)new Triple(s, p, o), (Object)x);
    }

    @Test
    public void esc_4() {
        int ch = 65553;
        String str = new String(Character.toChars(ch));
        Triple x = this.readTriple("<s> <p> \"X\\U00010011Y\" .");
        TestNTriples.assertNotNull((Object)x);
        Node s = Node.createURI((String)"s");
        Node p = Node.createURI((String)"p");
        Node o = Node.createLiteral((String)("X" + str + "Y"));
        TestNTriples.assertEquals((Object)new Triple(s, p, o), (Object)x);
    }

    @Test
    public void comment_1() {
        Graph g = this.parse("#Comment <x> <p> <z> .");
        TestNTriples.assertEquals((long)0L, (long)g.size());
    }

    @Test
    public void comment_2() {
        Graph g = this.parse("#Comment\n<x> <p> <z> .");
        TestNTriples.assertEquals((long)1L, (long)g.size());
    }

    @Test
    public void comment_3() {
        Graph g = this.parse("#Comment\r<x> <p> <z> .");
        TestNTriples.assertEquals((long)1L, (long)g.size());
    }

    @Test
    public void comment_4() {
        Graph g = this.parse("#Comment\r\n<x> <p> <z> .");
        TestNTriples.assertEquals((long)1L, (long)g.size());
    }

    @Test
    public void comment_5() {
        Graph g = this.parse("<x> <p> <z> .\n#Comment \n\n<x1> <p1> <z1> .");
        TestNTriples.assertEquals((long)2L, (long)g.size());
    }

    @Test
    public void comment_6() {
        Graph g = this.parse("<x> <p> <z> .\n<x1> <p1> <z1> .\r\n#Comment");
        TestNTriples.assertEquals((long)2L, (long)g.size());
    }

    @Test
    public void comment_7() {
        Graph g = this.parse("<x> <p> <z> .\r#Comment");
        TestNTriples.assertEquals((long)1L, (long)g.size());
    }

    private Node readNode(String form) {
        NodeTupleReader b = this.make(form);
        Node x = b.readNode();
        return x;
    }

    private Triple readTriple(String form) {
        NodeTupleReader b = this.make(form);
        Tuple<Node> t = b.readTuple();
        if (t == null) {
            return null;
        }
        return new Triple(t.get(0), t.get(1), t.get(2));
    }

    private Graph parse(String contents) {
        Graph graph = GraphUtils.makePlainGraph();
        StringReader r = new StringReader(contents);
        NodeTupleReader.read(graph, (Reader)r, null);
        return graph;
    }

    private NodeTupleReader make(String contents) {
        return new NodeTupleReader(contents);
    }
}

