/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.reader;

import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import lib.Log;

public final class PeekReader
extends Reader {
    static final int CB_SIZE = 16384;
    static final byte CHAR0 = 0;
    static final int EOF = -1;
    static final int UNSET = -2;
    private final char[] chars;
    private int buffLen = 0;
    private int idx = 0;
    private int currChar = -2;
    private Reader in;
    private int colNum = 0;
    private int lineNum = 1;

    public static PeekReader make(Reader r) {
        if (r instanceof PeekReader) {
            return (PeekReader)r;
        }
        if (r instanceof BufferedReader) {
            Log.warn(PeekReader.class, "BufferedReader passed to PeekReader");
        }
        return new PeekReader(r);
    }

    public static PeekReader makeUTF8(InputStream in) {
        Reader r = FileUtils.asUTF8((InputStream)in);
        return PeekReader.make(r);
    }

    private PeekReader(Reader in) {
        this(in, 16384);
    }

    static PeekReader make(String x) {
        return new PeekReader(new StringReader(x));
    }

    static PeekReader make(String x, int buffSize) {
        return new PeekReader(new StringReader(x), buffSize);
    }

    private PeekReader(Reader in, int buffSize) {
        this.chars = new char[buffSize];
        this.in = in;
        this.oneChar();
        if (this.currChar == -2) {
            this.currChar = -1;
        }
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public int getColNum() {
        return this.colNum;
    }

    public int peekChar() {
        return this.currChar;
    }

    public int readChar() {
        return this.oneChar();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        if (this.eof()) {
            return -1;
        }
        int x = this.oneChar();
        return x;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.eof()) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            int ch = this.oneChar();
            if (this.eof()) {
                return i;
            }
            cbuf[i + off] = (char)ch;
        }
        return len;
    }

    private void fill() {
        if (this.idx >= this.buffLen) {
            try {
                int x = this.in.read(this.chars);
                this.idx = 0;
                if (x <= 0) {
                    this.currChar = -1;
                }
                this.buffLen = x;
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    private int oneChar() {
        int ch = this.currChar;
        if (ch == -1) {
            return -1;
        }
        this.fill();
        if (!this.eof()) {
            this.currChar = this.chars[this.idx];
            ++this.idx;
            if (ch == 10) {
                ++this.lineNum;
                this.colNum = 1;
            } else {
                ++this.colNum;
            }
        }
        return ch;
    }

    public final boolean eof() {
        return this.currChar == -1;
    }
}

