/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.reader;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIFactory;
import com.hp.hpl.jena.iri.Violation;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.SyntaxError;
import com.hp.hpl.jena.sparql.core.Closeable;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.tdb.base.reader.PeekReader;
import com.hp.hpl.jena.tdb.base.reader.RollForwardErrorHandler;
import event.Event;
import event.EventListener;
import event.EventManager;
import event.EventType;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import lib.CacheSetLRU;
import lib.InternalError;
import lib.Tuple;

public final class NodeTupleReader {
    static final int EOF = -1;
    static final int NL = 10;
    static final int CR = 13;
    static final EventType startRead = new EventType("StartRead");
    static final EventType finishRead = new EventType("FinishRead");
    private TupleSink sink;
    private Hashtable<String, Node> anons = new Hashtable();
    private PeekReader in = null;
    private boolean inErr = false;
    private int errCount = 0;
    private static final int sbLength = 200;
    private RDFErrorHandler errorHandler = new RollForwardErrorHandler();
    private String msgBase;
    public static boolean CheckingNTriples = true;
    public static boolean CheckingIRIs = false;
    public static boolean KeepParsingAfterError = true;
    final StringBuilder buffer = new StringBuilder(200);
    static Tuple<Node> endMarker = Tuple.blankTuple(0);
    Tuple<Node> lastTuple = null;
    static IRIFactory iriFactory = IRIFactory.semanticWebImplementation();
    CacheSetLRU<String> cache = new CacheSetLRU(1000);

    public static TupleSink graphSink(Graph graph) {
        GraphTupleSink sink = new GraphTupleSink(graph);
        return sink;
    }

    public static void read(TupleSink sink, InputStream input, String base) {
        PeekReader r = PeekReader.makeUTF8(input);
        NodeTupleReader._read(sink, r, base);
    }

    public static void read(TupleSink sink, String string, String base) {
        PeekReader r = PeekReader.make(new StringReader(string));
        NodeTupleReader._read(sink, r, base);
    }

    public static void read(Graph graph, InputStream input, String base) {
        TupleSink sink = NodeTupleReader.graphSink(graph);
        NodeTupleReader.read(sink, input, base);
    }

    public static void read(Graph graph, String string, String base) {
        TupleSink sink = NodeTupleReader.graphSink(graph);
        NodeTupleReader.read(sink, string, base);
    }

    public static void read(Graph graph, Reader reader, String base) {
        TupleSink sink = NodeTupleReader.graphSink(graph);
        PeekReader r = PeekReader.make(reader);
        NodeTupleReader._read(sink, r, base);
    }

    public static void read(TupleSink sink, Reader reader, String base) {
        PeekReader r = PeekReader.make(reader);
        NodeTupleReader.read(sink, r, base);
    }

    public static void read(TupleSink sink, PeekReader peekReader, String base) {
        NodeTupleReader._read(sink, peekReader, base);
    }

    private static void _read(TupleSink sink, PeekReader peekReader, String base) {
        NodeTupleReader x = new NodeTupleReader(sink, peekReader, base);
        NodeTupleReader.invoke(x);
    }

    private static void invoke(NodeTupleReader x) {
        x.readRDF();
    }

    private static void invokeParallel(final NodeTupleReader x) {
        final ArrayBlockingQueue queue = new ArrayBlockingQueue(10000);
        TupleSink pipeSink = new TupleSink(){

            @Override
            public void tuple(Tuple<Node> tuple) {
                try {
                    queue.put(tuple);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    throw new InternalError("NodeTupleReader: InterruptedException");
                }
            }

            public void close() {
                this.tuple(endMarker);
            }
        };
        TupleSink output = x.sink;
        x.sink = pipeSink;
        Runnable parser = new Runnable(){

            @Override
            public void run() {
                x.readRDF();
            }
        };
        Thread t1 = new Thread(parser);
        t1.start();
        try {
            Tuple t;
            while ((t = (Tuple)queue.take()) != endMarker) {
                output.tuple(t);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            throw new InternalError("NodeTupleReader: InterruptedException");
        }
    }

    NodeTupleReader(String string) {
        this(new NullSink(), PeekReader.make(string), null);
    }

    private NodeTupleReader(TupleSink sink, PeekReader reader, String base) {
        this.sink = sink;
        this.msgBase = base == null ? "" : base + ": ";
        this.in = reader;
    }

    private void readRDF() {
        boolean noCache = false;
        if (noCache) {
            Node.cache((boolean)false);
        }
        try {
            EventManager.send(this.sink, new Event(startRead, null));
            this.process();
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
        finally {
            EventManager.send(this.sink, new Event(finishRead, null));
            if (noCache) {
                Node.cache((boolean)true);
            }
        }
        if (!KeepParsingAfterError && this.errCount > 0) {
            throw new SyntaxError("Unknown");
        }
        this.sink.close();
    }

    private final void process() {
        while (!this.in.eof()) {
            this.inErr = false;
            this.readOne();
            if (!this.inErr || KeepParsingAfterError) continue;
            return;
        }
    }

    Tuple<Node> readTuple() {
        this.readOne();
        return this.lastTuple;
    }

    void readOne() {
        Node subject = null;
        Node predicate = null;
        Node object = null;
        this.skipWhiteSpace();
        if (this.in.eof()) {
            return;
        }
        subject = this.readNode();
        if (this.inErr) {
            this.skipToNewlineLax();
            return;
        }
        if (CheckingNTriples && !subject.isURI() && !subject.isBlank()) {
            this.syntaxError("Subject is not an IRI or blank node");
            subject = null;
            return;
        }
        this.skipWhiteSpace();
        predicate = this.readNode();
        if (this.inErr) {
            this.skipToNewlineLax();
            return;
        }
        if (CheckingNTriples && !predicate.isURI()) {
            this.syntaxError("Predicate is not an IRI");
            predicate = null;
            return;
        }
        this.skipWhiteSpace();
        object = this.readNode();
        if (this.inErr) {
            this.skipToNewlineLax();
            return;
        }
        if (CheckingNTriples && !object.isURI() && !object.isBlank() && !object.isLiteral()) {
            this.syntaxError("Object is not an IRI, blank node or literal");
            object = null;
            return;
        }
        this.skipWhiteSpace();
        int ch = this.in.readChar();
        if (ch != 46) {
            this.syntaxError("End of triple not found");
            subject = null;
            predicate = null;
            object = null;
            this.skipToNewlineStrict();
            return;
        }
        if (subject != null && predicate != null && object != null) {
            try {
                this.emit(subject, predicate, object);
            }
            catch (JenaException ex) {
                String sStr = FmtUtils.stringForNode((Node)subject);
                String pStr = FmtUtils.stringForNode((Node)predicate);
                String oStr = FmtUtils.stringForNode((Node)object);
                String x = sStr + " " + pStr + " " + oStr;
                this.warning(x + " : " + ex.getMessage(), this.in.getLineNum(), -1);
            }
        }
    }

    private void emit(Node ... nodes) {
        if (CheckingNTriples && nodes.length != 3) {
            this.syntaxError("Not a 3-tuple");
            return;
        }
        Tuple<Node> t = Tuple.create(nodes);
        this.lastTuple = t;
        if (this.sink != null) {
            this.sink.tuple(t);
        }
    }

    Node readNode() {
        this.inErr = false;
        switch (this.in.peekChar()) {
            case -1: {
                this.syntaxError("unexpected input");
                return null;
            }
            case 34: {
                return this.readLiteral();
            }
            case 60: {
                return this.readURI();
            }
            case 95: {
                return this.readBlank();
            }
        }
        this.syntaxError("unexpected input");
        return null;
    }

    private final int readUnicode4Escape() {
        return this.readUnicodeEscape(4);
    }

    private final int readUnicodeEscape(int N) {
        int x = 0;
        for (int i = 0; i < N; ++i) {
            int d = this.readHex();
            if (d < 0) {
                return -1;
            }
            x = (x << 4) + d;
        }
        return x;
    }

    private final int readHex() {
        int ch = this.in.readChar();
        if (ch == -1) {
            this.syntaxError("Not a hexadecimal character (end of file)");
        }
        if (this.range(ch, '0', '9')) {
            return ch - 48;
        }
        if (this.range(ch, 'a', 'f')) {
            return ch - 97 + 10;
        }
        if (this.range(ch, 'A', 'F')) {
            return ch - 65 + 10;
        }
        this.syntaxError("Not a hexadecimal character: " + (char)ch);
        return -1;
    }

    private Node readURI() {
        String iri = this.readIRIStr();
        if (CheckingIRIs) {
            this.checkIRI(iri);
        }
        return Node.createURI((String)iri);
    }

    private Node readLiteral() {
        this.buffer.setLength(0);
        this.in.readChar();
        block0: while (!this.badEOF()) {
            int ch = this.in.readChar();
            if (ch == 92) {
                char[] pair;
                ch = this.readLiteralEscape();
                if (Character.charCount(ch) == 1) {
                    this.buffer.append((char)ch);
                    continue;
                }
                char[] arr$ = pair = Character.toChars(ch);
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block0;
                    char chSub = arr$[i$];
                    this.buffer.append(chSub);
                    ++i$;
                }
            }
            if (ch == 34) {
                String lex = this.buffer.toString();
                String lang = "";
                if (64 == this.in.peekChar()) {
                    this.in.readChar();
                    lang = this.readLang();
                }
                RDFDatatype dt = null;
                if (94 == this.in.peekChar()) {
                    this.expect("^^");
                    if (this.in.peekChar() != 60) {
                        this.syntaxError("Datatype IRI expected");
                        return null;
                    }
                    String datatypeURI = this.readIRIStr();
                    if (!lang.isEmpty()) {
                        this.syntaxError("Language tags are not permitted on typed literals.");
                    }
                    dt = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
                }
                if (dt == null) {
                    return Node.createLiteral((String)lex, (String)lang, null);
                }
                return Node.createLiteral((String)lex, null, dt);
            }
            this.buffer.append((char)ch);
        }
        return null;
    }

    private Node readBlank() {
        this.expect("_:");
        this.buffer.setLength(0);
        while (true) {
            int ch = this.in.peekChar();
            if (this.in.eof() || Character.isWhitespace(ch)) break;
            this.in.readChar();
            this.buffer.append((char)ch);
        }
        String label = this.buffer.toString();
        Node b = this.anons.get(label);
        if (b == null) {
            b = Node.createAnon((AnonId)new AnonId(label));
            this.anons.put(label, b);
        }
        return b;
    }

    private String readIRIStr() {
        int ch;
        this.in.readChar();
        this.buffer.setLength(0);
        while ((ch = this.in.readChar()) != 62) {
            if (ch == 92) {
                ch = this.expect("u") ? this.readUnicode4Escape() : 95;
            }
            this.buffer.append((char)ch);
        }
        return this.buffer.toString();
    }

    private void checkIRI(String iriStr) {
        if (this.cache.contains(iriStr)) {
            return;
        }
        boolean includeWarnings = true;
        IRI iri = iriFactory.create(iriStr);
        if (iri.hasViolation(includeWarnings)) {
            Iterator it = iri.violations(includeWarnings);
            while (it.hasNext()) {
                Violation v = (Violation)it.next();
                if (v.isError()) {
                    this.syntaxError(v.getShortMessage());
                    continue;
                }
                if (!includeWarnings) continue;
                this.warning(v.getShortMessage());
            }
        } else {
            this.cache.add(iriStr);
        }
    }

    private boolean range(int ch, char a, char b) {
        return ch >= a && ch <= b;
    }

    private int readLiteralEscape() {
        int c = this.in.readChar();
        if (this.in.eof()) {
            this.inErr = true;
            return 0;
        }
        switch (c) {
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 34: {
                return 34;
            }
            case 92: {
                return 92;
            }
            case 117: {
                return this.readUnicode4Escape();
            }
            case 85: {
                int ch8 = this.readUnicodeEscape(8);
                if (ch8 > 0x10FFFF) {
                    this.syntaxError(String.format("illegal code point in \\U sequence value: 0x%08X", ch8));
                    return 0;
                }
                return ch8;
            }
        }
        this.syntaxError(String.format("illegal escape sequence value: %c (0x%02X)", c, c));
        return 0;
    }

    private void warning(String s) {
        this.warning(s, this.in.getLineNum(), this.in.getColNum());
    }

    private void warning(String s, int line, int charpos) {
        this.errorHandler.warning((Exception)new SyntaxError(this.syntaxErrorMessage("Warning", s, line, charpos)));
    }

    private void syntaxError(String s) {
        this.syntaxError(s, this.in.getLineNum(), this.in.getColNum());
    }

    private void syntaxError(String s, int line, int charpos) {
        ++this.errCount;
        this.errorHandler.error((Exception)this.syntaxException(s, line, charpos));
        this.inErr = true;
    }

    private SyntaxError syntaxException(String s, int lineNum, int charpos) {
        return new SyntaxError(this.syntaxErrorMessage("Syntax error", s, lineNum, charpos));
    }

    private String readLang() {
        int inChar;
        this.buffer.setLength(0);
        while (this.range(inChar = this.in.peekChar(), 'a', 'z') || this.range(inChar, 'A', 'Z') || inChar == 45) {
            inChar = this.in.readChar();
            this.buffer.append((char)inChar);
        }
        return this.buffer.toString();
    }

    private boolean badEOF() {
        if (this.in.eof()) {
            this.inErr = true;
            this.syntaxError("premature end of file");
        }
        return this.inErr;
    }

    private boolean expect(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char want = str.charAt(i);
            if (this.badEOF()) {
                return false;
            }
            int inChar = this.in.readChar();
            if (inChar == want) continue;
            this.syntaxError("expected \"" + str + "\"");
            return false;
        }
        return true;
    }

    private void skipWhiteSpace() {
        while (!this.in.eof()) {
            int ch = this.in.peekChar();
            if (!Character.isWhitespace(ch) && ch != 35) {
                return;
            }
            if (ch == 35) {
                this.comment();
                continue;
            }
            this.in.readChar();
        }
        return;
    }

    private void skipToNewlineStrict() {
        int ch;
        while (!this.in.eof() && (ch = this.in.readChar()) != 10) {
            if (ch != 13) continue;
            if (this.in.peekChar() != 10) break;
            this.in.readChar();
            break;
        }
    }

    private void skipToNewlineLax() {
        this.skipToNewlineStrict();
        this.skipCurrentNewlineChars();
    }

    private void skipCurrentNewlineChars() {
        int ch;
        while (!this.in.eof() && (ch = this.in.peekChar()) == 10 && ch == 13) {
            this.in.readChar();
        }
    }

    private void comment() {
        while (!this.in.eof()) {
            int ch = this.in.readChar();
            if (ch == 10) {
                return;
            }
            if (ch != 13) continue;
            if (this.in.peekChar() == 10) {
                this.in.readChar();
            }
            return;
        }
    }

    private String syntaxErrorMessage(String sort, String msg, int linepos, int charpos) {
        StringBuilder x = new StringBuilder();
        x.append(this.msgBase);
        if (sort != null) {
            x.append(sort);
            x.append(" at line ");
        } else {
            x.append("Line ");
        }
        x.append(Integer.toString(linepos));
        if (charpos >= 0) {
            x.append(" position ");
            x.append(Integer.toString(charpos));
        }
        x.append(": ");
        x.append(msg);
        return x.toString();
    }

    public static final class CountingSink
    implements TupleSink {
        public long count = 0L;

        @Override
        public void tuple(Tuple<Node> tuple) {
            ++this.count;
        }

        public void close() {
        }
    }

    public static final class NullSink
    implements TupleSink {
        @Override
        public void tuple(Tuple<Node> tuple) {
        }

        public void close() {
        }
    }

    static final class GraphTupleSink
    implements TupleSink {
        private final Graph graph;
        EventListener el1;
        EventListener el2;

        GraphTupleSink(Graph g) {
            this.graph = g;
            this.el1 = new EventListener(){

                @Override
                public void event(Object dest, Event event) {
                    GraphTupleSink.this.graph.getEventManager().notifyEvent(GraphTupleSink.this.graph, (Object)GraphEvents.startRead);
                }
            };
            this.el2 = new EventListener(){

                @Override
                public void event(Object dest, Event event) {
                    GraphTupleSink.this.graph.getEventManager().notifyEvent(GraphTupleSink.this.graph, (Object)GraphEvents.finishRead);
                }
            };
            EventManager.register(this, startRead, this.el1);
            EventManager.register(this, finishRead, this.el2);
        }

        @Override
        public void tuple(Tuple<Node> tuple) {
            if (tuple.size() != 3) {
                throw new InternalError("Tuple not of length 3 for a triple");
            }
            Triple t = new Triple(tuple.get(0), tuple.get(1), tuple.get(2));
            this.graph.add(t);
        }

        public void close() {
            EventManager.unregister(this, startRead, this.el1);
            EventManager.unregister(this, startRead, this.el2);
        }
    }

    public static interface TupleSink
    extends Closeable {
        public void tuple(Tuple<Node> var1);
    }
}

