/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.objectfile;

import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import lib.Bytes;

public class ObjectFileMem
implements ObjectFile {
    List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();

    @Override
    public NodeId write(String str) {
        ByteBuffer bb = ByteBuffer.allocate(4 * str.length());
        Bytes.toByteBuffer(str, bb);
        int len = bb.position();
        bb.limit(len);
        int x = this.buffers.size();
        this.buffers.add(bb);
        return NodeId.create(x);
    }

    private ByteBuffer readBytes(NodeId id) {
        int x = (int)id.getId();
        ByteBuffer bb = this.buffers.get(x);
        bb.position(0);
        ByteBuffer bb2 = ByteBuffer.allocate(bb.limit());
        bb2.put(bb);
        bb2.position(0);
        return bb2;
    }

    @Override
    public String read(NodeId id) {
        ByteBuffer bb = this.readBytes(id);
        return Bytes.fromByteBuffer(bb);
    }

    @Override
    public List<String> all() {
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < this.buffers.size(); ++i) {
            String str = this.read(NodeId.create(i));
            strings.add(str);
        }
        return strings;
    }

    @Override
    public void close() {
    }

    @Override
    public void sync(boolean force) {
    }

    @Override
    public void dump() {
        for (int i = 0; i < this.buffers.size(); ++i) {
            String str = this.read(NodeId.create(i));
            System.out.printf("0x%08X : %s\n", i, str);
        }
    }
}

