/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.objectfile;

import com.hp.hpl.jena.tdb.base.block.BlockException;
import com.hp.hpl.jena.tdb.base.file.FileException;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

class ObjectFileDisk_DataIO
implements ObjectFile {
    private RandomAccessFile out;
    private long filesize;

    ObjectFileDisk_DataIO(String filename) {
        try {
            this.out = new RandomAccessFile(filename, "rw");
            this.filesize = this.out.length();
        }
        catch (IOException ex) {
            throw new BlockException("Failed to create ObjectFileDisk", ex);
        }
    }

    @Override
    public NodeId write(String str) {
        try {
            long id = this.filesize;
            this.out.seek(this.filesize);
            this.out.writeUTF(str);
            this.filesize = this.out.length();
            return NodeId.create(id);
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.write", ex);
        }
    }

    @Override
    public String read(NodeId id) {
        try {
            this.out.seek(id.getId());
            String s = this.out.readUTF();
            return s;
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.read", ex);
        }
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.close", ex);
        }
    }

    @Override
    public void sync(boolean force) {
        try {
            this.out.getChannel().force(true);
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.sync", ex);
        }
    }

    @Override
    public List<String> all() {
        try {
            ArrayList<String> strings = new ArrayList<String>();
            this.out.seek(0L);
            try {
                while (true) {
                    String s = this.out.readUTF();
                    strings.add(s);
                }
            }
            catch (EOFException eOFException) {
                return strings;
            }
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.all", ex);
        }
    }

    @Override
    public void dump() {
        System.out.println("No dump implemented");
    }
}

