/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.objectfile;

import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.block.BlockException;
import com.hp.hpl.jena.tdb.base.file.FileBase;
import com.hp.hpl.jena.tdb.base.file.FileException;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.lib.StringAbbrev;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import lib.Bytes;
import lib.Pair;

public class ObjectFileDiskWithCache
extends FileBase
implements ObjectFile {
    private long filesize;
    int delayCacheSize = 100;
    List<Pair<NodeId, String>> delayCache = this.delayCacheSize == -1 ? null : new ArrayList(this.delayCacheSize);
    ByteBuffer buffer = this.delayCacheSize == -1 ? null : ByteBuffer.allocate(this.delayCacheSize * 100);
    long idAllocation;
    public static final boolean compression = false;
    private static StringAbbrev abbreviations = new StringAbbrev();

    public ObjectFileDiskWithCache(String filename) {
        super(filename);
        try {
            this.idAllocation = this.filesize = this.out.length();
        }
        catch (IOException ex) {
            throw new BlockException("Failed to get filesize", ex);
        }
    }

    @Override
    public NodeId write(String str) {
        if (this.delayCache != null && this.delayCache.size() >= this.delayCacheSize) {
            this.flushCache();
        }
        str = this.compress(str);
        if (this.buffer == null) {
            this._writeNow(str);
        }
        int max = 4 + 4 * str.length();
        int x = this.buffer.position();
        if (x + max > this.buffer.limit()) {
            this.flushCache();
            if (max > this.buffer.limit()) {
                return this._writeNow(str);
            }
        }
        this.buffer.position(x + 4);
        Bytes.toByteBuffer(str, this.buffer);
        int y = this.buffer.position();
        int len = y - x - 4;
        this.buffer.position(x);
        this.buffer.putInt(0, len);
        this.buffer.position(y);
        long location = this.idAllocation;
        this.idAllocation = this.idAllocation + (long)len + 4L;
        NodeId nodeId = NodeId.create(location);
        this.delayCache.add(new Pair<NodeId, String>(nodeId, str));
        return nodeId;
    }

    private NodeId _writeNow(String str) {
        try {
            long location = this.filesize;
            ByteBuffer bb = ByteBuffer.allocate(4 + 4 * str.length());
            bb.position(4);
            Bytes.toByteBuffer(str, bb);
            int len = bb.position() - 4;
            bb.limit(len + 4);
            bb.putInt(0, len);
            bb.position(0);
            int x = this.channel.write(bb);
            if (x != bb.limit()) {
                throw new FileException("ObjectFile.write: Buffer length = " + bb.limit() + " : actual write = " + x);
            }
            this.filesize += (long)x;
            return NodeId.create(location);
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.write", ex);
        }
    }

    private void flushCache() {
        if (this.delayCache == null) {
            return;
        }
        long id = this.filesize;
        try {
            this.buffer.flip();
            long x = this.channel.write(this.buffer);
            if (x != this.idAllocation - this.filesize) {
                throw new FileException("ObjectFile.flushCache: Buffer length = " + (this.idAllocation - this.filesize) + " : actual write = " + x);
            }
            this.filesize = this.idAllocation;
            this.buffer.clear();
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.write", ex);
        }
        this.delayCache.clear();
        this.buffer.clear();
    }

    @Override
    public String read(NodeId id) {
        String x = null;
        if (id.getId() > this.filesize) {
            x = this.findInCache(id);
        } else {
            ByteBuffer bb = this.readBytes(id);
            x = Bytes.fromByteBuffer(bb);
        }
        x = this.decompress(x);
        return x;
    }

    private String findInCache(NodeId id) {
        for (Pair<NodeId, String> elt : this.delayCache) {
            NodeId n = elt.car();
            if (n.equals(id)) {
                return elt.cdr();
            }
            if (n.getId() >= elt.car().getId()) continue;
            break;
        }
        throw new TDBException("Asked for impossible NodeId: " + id);
    }

    private ByteBuffer readBytes(NodeId id) {
        return this.readBytes(id.getId());
    }

    private ByteBuffer readBytes(long loc) {
        try {
            ByteBuffer bb = ByteBuffer.allocate(4);
            this.channel.position(loc);
            int x = this.channel.read(bb);
            if (x != 4) {
                throw new FileException("ObjectFile.read: Failed to read the length : got " + x + " bytes");
            }
            int len = bb.getInt(0);
            bb = ByteBuffer.allocate(len);
            this.channel.position(loc + 4L);
            x = this.channel.read(bb);
            bb.position(0);
            bb.limit(len);
            if (x != len) {
                throw new FileException("ObjectFile.read: Failed to read the object (" + len + " bytes) : got " + x + " bytes");
            }
            return bb;
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.read", ex);
        }
    }

    @Override
    public void close() {
        this.flushCache();
        try {
            this.channel.close();
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.close", ex);
        }
    }

    @Override
    public void sync(boolean force) {
        if (force) {
            this.flushCache();
        }
    }

    @Override
    public List<String> all() {
        try {
            this.out.seek(0L);
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.all", ex);
        }
        ArrayList<String> strings = new ArrayList<String>();
        long x = 0L;
        while (x < this.filesize) {
            ByteBuffer bb = this.readBytes(x);
            String str = Bytes.fromByteBuffer(bb);
            strings.add(str);
            x = x + (long)bb.limit() + 4L;
        }
        return strings;
    }

    @Override
    public void dump() {
        try {
            this.out.seek(0L);
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.all", ex);
        }
        long fileIdx = 0L;
        while (fileIdx < this.filesize) {
            ByteBuffer bb = this.readBytes(fileIdx);
            String str = Bytes.fromByteBuffer(bb);
            System.out.printf("0x%08X : %s\n", fileIdx, str);
            fileIdx = fileIdx + (long)bb.limit() + 4L;
        }
    }

    private String compress(String str) {
        return str;
    }

    private String decompress(String x) {
        return x;
    }

    static {
        abbreviations.add("rdf", "<http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        abbreviations.add("rdfs", "<http://www.w3.org/2000/01/rdf-schema#");
        abbreviations.add("xsd", "<http://www.w3.org/2001/XMLSchema#");
        abbreviations.add("mal", "<http://musicbrainz.org/mm-2.1/album/");
        abbreviations.add("mt", "<http://musicbrainz.org/mm-2.1/track/");
        abbreviations.add("mar", "<http://musicbrainz.org/mm-2.1/artist/");
        abbreviations.add("mtr", "<http://musicbrainz.org/mm-2.1/trmid/");
        abbreviations.add("mc", "<http://musicbrainz.org/mm-2.1/cdindex/");
        abbreviations.add("m21", "<http://musicbrainz.org/mm/mm-2.1#");
        abbreviations.add("dc", "<http://purl.org/dc/elements/1.1/");
        abbreviations.add("r", "<http://dbpedia/resource/");
        abbreviations.add("p", "<http://dbpedia/property/");
    }
}

