/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.objectfile;

import com.hp.hpl.jena.tdb.base.block.BlockException;
import com.hp.hpl.jena.tdb.base.file.FileBase;
import com.hp.hpl.jena.tdb.base.file.FileException;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.lib.StringAbbrev;
import com.hp.hpl.jena.tdb.store.NodeId;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import lib.Bytes;

public class ObjectFileDiskDirect
extends FileBase
implements ObjectFile {
    private long filesize;
    public static final boolean compression = false;
    private static StringAbbrev abbreviations = new StringAbbrev();

    public ObjectFileDiskDirect(String filename) {
        super(filename);
        try {
            this.filesize = this.out.length();
        }
        catch (IOException ex) {
            throw new BlockException("Failed to get filesize", ex);
        }
    }

    @Override
    public NodeId write(String str) {
        str = this.compress(str);
        ByteBuffer bb = ByteBuffer.allocate(4 + 4 * str.length());
        bb.position(4);
        Bytes.toByteBuffer(str, bb);
        int len = bb.position() - 4;
        bb.limit(len + 4);
        bb.putInt(0, len);
        bb.position(0);
        try {
            long location = this.filesize;
            this.channel.position(location);
            int x = this.channel.write(bb);
            if (x != len + 4) {
                throw new FileException("ObjectFile.write: Buffer length = " + len + " : actual write = " + x);
            }
            this.filesize += (long)x;
            return NodeId.create(location);
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.write", ex);
        }
    }

    @Override
    public String read(NodeId id) {
        ByteBuffer bb = this.readBytes(id);
        String x = Bytes.fromByteBuffer(bb);
        x = this.decompress(x);
        return x;
    }

    private ByteBuffer readBytes(NodeId id) {
        return this.readBytes(id.getId());
    }

    private ByteBuffer readBytes(long loc) {
        try {
            ByteBuffer bb = ByteBuffer.allocate(4);
            this.channel.position(loc);
            int x = this.channel.read(bb);
            if (x != 4) {
                throw new FileException("ObjectFile.read: Failed to read the length : got " + x + " bytes");
            }
            int len = bb.getInt(0);
            bb = ByteBuffer.allocate(len);
            this.channel.position(loc + 4L);
            x = this.channel.read(bb);
            bb.position(0);
            bb.limit(len);
            if (x != len) {
                throw new FileException("ObjectFile.read: Failed to read the object (" + len + " bytes) : got " + x + " bytes");
            }
            return bb;
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.read", ex);
        }
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.close", ex);
        }
    }

    @Override
    public void sync(boolean force) {
    }

    @Override
    public List<String> all() {
        try {
            this.out.seek(0L);
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.all", ex);
        }
        ArrayList<String> strings = new ArrayList<String>();
        long x = 0L;
        while (x < this.filesize) {
            ByteBuffer bb = this.readBytes(x);
            String str = Bytes.fromByteBuffer(bb);
            strings.add(str);
            x = x + (long)bb.limit() + 4L;
        }
        return strings;
    }

    @Override
    public void dump() {
        try {
            this.out.seek(0L);
        }
        catch (IOException ex) {
            throw new FileException("ObjectFile.all", ex);
        }
        long fileIdx = 0L;
        while (fileIdx < this.filesize) {
            ByteBuffer bb = this.readBytes(fileIdx);
            String str = Bytes.fromByteBuffer(bb);
            System.out.printf("0x%08X : %s\n", fileIdx, str);
            fileIdx = fileIdx + (long)bb.limit() + 4L;
        }
    }

    private String compress(String str) {
        return str;
    }

    private String decompress(String x) {
        return x;
    }

    static {
        abbreviations.add("rdf", "<http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        abbreviations.add("rdfs", "<http://www.w3.org/2000/01/rdf-schema#");
        abbreviations.add("xsd", "<http://www.w3.org/2001/XMLSchema#");
        abbreviations.add("mal", "<http://musicbrainz.org/mm-2.1/album/");
        abbreviations.add("mt", "<http://musicbrainz.org/mm-2.1/track/");
        abbreviations.add("mar", "<http://musicbrainz.org/mm-2.1/artist/");
        abbreviations.add("mtr", "<http://musicbrainz.org/mm-2.1/trmid/");
        abbreviations.add("mc", "<http://musicbrainz.org/mm-2.1/cdindex/");
        abbreviations.add("m21", "<http://musicbrainz.org/mm/mm-2.1#");
        abbreviations.add("dc", "<http://purl.org/dc/elements/1.1/");
        abbreviations.add("r", "<http://dbpedia/resource/");
        abbreviations.add("p", "<http://dbpedia/property/");
    }
}

