/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.block.BlockException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class MetaFile {
    Properties prop = new Properties();
    private String filename;

    public MetaFile(String fn) {
        if (!fn.endsWith(".meta")) {
            this.filename = fn + ".meta";
        }
        try {
            InputStream in = new FileInputStream(this.filename);
            in = new BufferedInputStream(in);
            this.prop.load(in);
            in.close();
        }
        catch (FileNotFoundException ex) {
            this.force();
        }
        catch (Exception ex) {
            throw new BlockException("Failed to load properties", ex);
        }
    }

    Properties getProperties() {
        return this.prop;
    }

    public void set(String key, String value) {
        this.prop.put(key, value);
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defaultValue) {
        return this.prop.getProperty(key, defaultValue);
    }

    public void force() {
        try {
            OutputStream out = new FileOutputStream(this.filename);
            out = new BufferedOutputStream(out);
            this.prop.store(out, "Jena block meta file");
            out.close();
        }
        catch (Exception ex) {
            throw new BlockException("Failed to store properties", ex);
        }
    }
}

