/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.file.FileException;
import java.io.File;

public class Location {
    static String pathSeparator = File.separator;
    String pathname;

    public static Location ensureDirectory(String dirname) {
        File file = new File(dirname);
        if (!file.exists() && !file.mkdirs()) {
            throw new FileException("Failed to create directory: " + file.getAbsolutePath());
        }
        if (!file.isDirectory()) {
            throw new FileException("Not a directory: " + file.getAbsolutePath());
        }
        Location loc = new Location();
        loc.setPathname(dirname);
        return loc;
    }

    private Location() {
    }

    private void setPathname(String pathname) {
        if (!pathname.endsWith(File.separator) && !pathname.endsWith(pathSeparator)) {
            pathname = pathname + pathSeparator;
        }
        this.pathname = pathname;
    }

    public Location(String rootname) {
        File file = new File(rootname);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!file.isDirectory()) {
            throw new FileException("Not a directory: " + file.getAbsolutePath());
        }
        this.setPathname(file.getAbsolutePath());
    }

    public String getDirectoryPath() {
        return this.pathname;
    }

    public Location getSubLocation(String dirname) {
        String newName = this.pathname + dirname;
        File file = new File(newName);
        if (file.exists() && !file.isDirectory()) {
            throw new FileException("Existing file: " + file.getAbsolutePath());
        }
        if (!file.exists()) {
            file.mkdir();
        }
        return new Location(newName);
    }

    public String getSubDirectory(String dirname) {
        return this.getSubLocation(dirname).getDirectoryPath();
    }

    public String absolute(String filename, String extension) {
        return extension == null ? this.absolute(filename) : this.absolute(filename + "." + extension);
    }

    public String absolute(String filename) {
        File f = new File(filename);
        if (!f.isAbsolute()) {
            filename = this.pathname + filename;
        }
        return filename;
    }

    public boolean exists(String filename) {
        return this.exists(filename, null);
    }

    public boolean exists(String filename, String ext) {
        String fn = this.getPath(filename, ext);
        File f = new File(fn);
        return f.exists();
    }

    public String getPath(String filename) {
        return this.getPath(filename, null);
    }

    public String getPath(String filename, String ext) {
        this.check(filename, ext);
        if (ext == null) {
            return this.pathname + filename;
        }
        return this.pathname + filename + "." + ext;
    }

    private void check(String filename, String ext) {
        if (filename == null) {
            throw new FileException("Location: null filename");
        }
        if (filename.contains("/") || filename.contains("\\")) {
            throw new FileException("Illegal file component name: " + filename);
        }
        if (filename.contains(".") && ext != null) {
            throw new FileException("Filename has an extension: " + filename);
        }
        if (ext != null && ext.contains(".")) {
            throw new FileException("Extension has an extension: " + filename);
        }
    }

    public String toString() {
        return "location:" + this.pathname;
    }
}

