/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.buffer;

import com.hp.hpl.jena.tdb.base.buffer.BufferException;
import com.hp.hpl.jena.tdb.base.buffer.RecordBuffer;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.base.record.RecordLib;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.util.Iterator;
import java.util.List;
import org.junit.BeforeClass;
import org.junit.Test;
import test.BaseTest;

public class TestRecordBuffer
extends BaseTest {
    static RecordFactory recordFactory;

    @BeforeClass
    public static void before() {
        recordFactory = new RecordFactory(4, 0);
        SystemTDB.NullOut = true;
    }

    @Test
    public void recBuffer01() {
        RecordBuffer rb = TestRecordBuffer.make(4, 4);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8);
    }

    @Test
    public void recBuffer02() {
        RecordBuffer rb = TestRecordBuffer.make(4, 4);
        int idx = -1;
        idx = this.find(rb, 6);
        TestRecordBuffer.assertEquals((long)2L, (long)idx);
        idx = this.find(rb, 8);
        TestRecordBuffer.assertEquals((long)3L, (long)idx);
        idx = this.find(rb, 4);
        TestRecordBuffer.assertEquals((long)1L, (long)idx);
        idx = this.find(rb, 2);
        TestRecordBuffer.assertEquals((long)0L, (long)idx);
        idx = this.find(rb, 3);
        TestRecordBuffer.assertEquals((long)-2L, (long)idx);
        idx = this.find(rb, 0);
        TestRecordBuffer.assertEquals((long)-1L, (long)idx);
        idx = this.find(rb, 10);
        TestRecordBuffer.assertEquals((long)-5L, (long)idx);
    }

    @Test
    public void recBuffer03() {
        RecordBuffer rb = TestRecordBuffer.make(4, 5);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8);
        rb.shiftUp(0);
        rb.set(0, RecordLib.r(0));
        TestRecordBuffer.contains(rb, 0, 2, 4, 6, 8);
        rb.shiftDown(0);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8);
    }

    @Test
    public void recBuffer04() {
        RecordBuffer rb = TestRecordBuffer.make(4, 5);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8);
        rb.shiftDown(0);
        TestRecordBuffer.contains(rb, 4, 6, 8);
        rb.shiftUp(0);
        rb.set(0, RecordLib.r(1));
        TestRecordBuffer.contains(rb, 1, 4, 6, 8);
    }

    @Test
    public void recBuffer05() {
        RecordBuffer rb = TestRecordBuffer.make(4, 5);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8);
        rb.shiftUp(2);
        rb.set(2, RecordLib.r(0));
        TestRecordBuffer.contains(rb, 2, 4, 0, 6, 8);
        rb.shiftDown(2);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8);
    }

    @Test
    public void recBuffer06() {
        RecordBuffer rb = TestRecordBuffer.make(4, 5);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8);
        rb.shiftDown(2);
        TestRecordBuffer.contains(rb, 2, 4, 8);
        rb.shiftUp(2);
        TestRecordBuffer.contains(rb, 2, 4, -1, 8);
    }

    @Test
    public void recBuffer07() {
        RecordBuffer rb = TestRecordBuffer.make(4, 5);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8);
        rb.shiftUp(3);
        rb.set(3, RecordLib.r(1));
        TestRecordBuffer.contains(rb, 2, 4, 6, 1, 8);
        rb.shiftDown(3);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8);
    }

    @Test
    public void recBuffer08() {
        RecordBuffer rb = TestRecordBuffer.make(4, 5);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8);
        rb.shiftDown(3);
        TestRecordBuffer.contains(rb, 2, 4, 6);
        rb.shiftUp(2);
        TestRecordBuffer.contains(rb, 2, 4, -1, 6);
    }

    @Test(expected=BufferException.class)
    public void recBuffer09() {
        RecordBuffer rb = TestRecordBuffer.make(4, 5);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8);
        rb.shiftDown(4);
    }

    @Test(expected=BufferException.class)
    public void recBuffer10() {
        RecordBuffer rb = TestRecordBuffer.make(4, 5);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8);
        rb.shiftUp(4);
    }

    @Test(expected=BufferException.class)
    public void recBuffer11() {
        RecordBuffer rb = TestRecordBuffer.make(5, 5);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8, 10);
        rb.add(RecordLib.r(12));
    }

    @Test
    public void recBuffer12() {
        RecordBuffer rb = TestRecordBuffer.make(5, 5);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8, 10);
        RecordBuffer rb2 = rb.duplicate();
        rb2.set(1, RecordLib.r(99));
        TestRecordBuffer.contains(rb, 2, 4, 6, 8, 10);
        TestRecordBuffer.contains(rb2, 2, 99, 6, 8, 10);
    }

    @Test
    public void recBuffer13() {
        RecordBuffer rb = TestRecordBuffer.make(5, 5);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8, 10);
        rb.clear(1, 3);
        TestRecordBuffer.contains(rb, 2, -1, -1, -1, 10);
    }

    @Test
    public void recBuffer14() {
        RecordBuffer rb = TestRecordBuffer.make(5, 5);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8, 10);
        RecordBuffer rb2 = TestRecordBuffer.make(5, 5);
        TestRecordBuffer.contains(rb2, 2, 4, 6, 8, 10);
        rb.copy(0, rb2, 1, 4);
        TestRecordBuffer.contains(rb2, 2, 2, 4, 6, 8);
    }

    @Test
    public void recBuffer15() {
        RecordBuffer rb = TestRecordBuffer.make(5, 5);
        TestRecordBuffer.contains(rb, 2, 4, 6, 8, 10);
        rb.removeTop();
        TestRecordBuffer.contains(rb, 2, 4, 6, 8);
        rb.remove(1);
        TestRecordBuffer.contains(rb, 2, 6, 8);
        rb.remove(2);
        TestRecordBuffer.contains(rb, 2, 6);
        rb.remove(0);
        TestRecordBuffer.contains(rb, 6);
        rb.remove(0);
        TestRecordBuffer.contains(rb, new int[0]);
    }

    @Test
    public void recBufferIterate01() {
        RecordBuffer rb = TestRecordBuffer.make(5, 5);
        TestRecordBuffer.same(rb.iterator(), 2, 4, 6, 8, 10);
    }

    @Test
    public void recBufferIterate02() {
        RecordBuffer rb = TestRecordBuffer.make(3, 5);
        Iterator<Record> iter = rb.iterator();
        TestRecordBuffer.same(iter, 2, 4, 6);
    }

    @Test
    public void recBufferIterate03() {
        RecordBuffer rb = TestRecordBuffer.make(3, 5);
        Iterator<Record> iter = rb.iterator(RecordLib.intToRecord(4), null);
        TestRecordBuffer.same(iter, 4, 6);
    }

    @Test
    public void recBufferIterate04() {
        RecordBuffer rb = TestRecordBuffer.make(3, 5);
        Iterator<Record> iter = rb.iterator(RecordLib.intToRecord(3), null);
        TestRecordBuffer.same(iter, 4, 6);
    }

    @Test
    public void recBufferIterate05() {
        RecordBuffer rb = TestRecordBuffer.make(3, 5);
        Iterator<Record> iter = rb.iterator(RecordLib.intToRecord(1), null);
        TestRecordBuffer.same(iter, 2, 4, 6);
    }

    @Test
    public void recBufferIterate06() {
        RecordBuffer rb = TestRecordBuffer.make(3, 5);
        Iterator<Record> iter = rb.iterator(null, RecordLib.intToRecord(1));
        TestRecordBuffer.same(iter, new int[0]);
    }

    @Test
    public void recBufferIterate07() {
        RecordBuffer rb = TestRecordBuffer.make(3, 5);
        Iterator<Record> iter = rb.iterator(null, RecordLib.intToRecord(2));
        TestRecordBuffer.same(iter, new int[0]);
    }

    @Test
    public void recBufferIterate08() {
        RecordBuffer rb = TestRecordBuffer.make(3, 5);
        Iterator<Record> iter = rb.iterator(null, RecordLib.intToRecord(3));
        TestRecordBuffer.same(iter, 2);
    }

    @Test
    public void recBufferIterate09() {
        RecordBuffer rb = TestRecordBuffer.make(5, 5);
        Iterator<Record> iter = rb.iterator(null, RecordLib.intToRecord(99));
        TestRecordBuffer.same(iter, 2, 4, 6, 8, 10);
    }

    @Test
    public void recBufferIterate10() {
        RecordBuffer rb = TestRecordBuffer.make(5, 5);
        Iterator<Record> iter = rb.iterator(RecordLib.intToRecord(4), RecordLib.intToRecord(8));
        TestRecordBuffer.same(iter, 4, 6);
    }

    @Test
    public void recBufferIterate11() {
        RecordBuffer rb = TestRecordBuffer.make(5, 5);
        Iterator<Record> iter = rb.iterator(RecordLib.intToRecord(3), RecordLib.intToRecord(9));
        TestRecordBuffer.same(iter, 4, 6, 8);
    }

    private static void contains(RecordBuffer rb, int ... vals) {
        TestRecordBuffer.assertEquals((String)"Length mismatch: ", (long)vals.length, (long)rb.size());
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == -1) {
                TestRecordBuffer.assertTrue((boolean)rb.isClear(i));
                continue;
            }
            Record r = RecordLib.intToRecord(vals[i]);
            Record r2 = rb.get(i);
            int x = RecordLib.recordToInt(r2);
            TestRecordBuffer.assertEquals((String)"Value mismatch: ", (long)vals[i], (long)x);
        }
    }

    private static void same(Iterator<Record> iter, int ... vals) {
        List<Integer> list = RecordLib.toIntList(iter);
        TestRecordBuffer.assertEquals((String)"Length mismatch: ", (long)vals.length, (long)list.size());
        for (int i = 0; i < vals.length; ++i) {
            int x = list.get(i);
            TestRecordBuffer.assertEquals((String)"Value mismatch: ", (long)vals[i], (long)x);
        }
    }

    public int find(RecordBuffer rb, int v) {
        return rb.find(RecordLib.r(v));
    }

    private static RecordBuffer make(int n, int len) {
        RecordBuffer rb = new RecordBuffer(recordFactory, len);
        for (int i = 0; i < n; ++i) {
            Record r = RecordLib.intToRecord(2 * i + 2);
            rb.add(r);
        }
        return rb;
    }
}

