/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.buffer;

import com.hp.hpl.jena.tdb.base.buffer.BufferBase;
import com.hp.hpl.jena.tdb.base.buffer.BufferException;
import com.hp.hpl.jena.tdb.base.buffer.RecordBufferIterator;
import com.hp.hpl.jena.tdb.base.record.Record;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import java.nio.ByteBuffer;
import java.util.Iterator;
import lib.Lib;

public final class RecordBuffer
extends BufferBase {
    private RecordFactory factory;

    public RecordBuffer(RecordFactory recFactory, int maxRec) {
        this(ByteBuffer.allocate(recFactory.recordLength() * maxRec), recFactory, 0);
    }

    public RecordBuffer(ByteBuffer bb, RecordFactory recFactory, int num) {
        super(bb, recFactory.recordLength(), num);
        this.factory = recFactory;
    }

    public Record get(int idx) {
        RecordBuffer.checkBounds(idx, this.numSlot);
        return this._get(idx);
    }

    public Record getLow() {
        if (this.numSlot == 0) {
            throw new IllegalArgumentException("Empty RecordBuffer");
        }
        return this._get(0);
    }

    public Record getHigh() {
        if (this.numSlot == 0) {
            throw new IllegalArgumentException("Empty RecordBuffer");
        }
        return this._get(this.numSlot - 1);
    }

    public void add(Record record) {
        this.add(this.numSlot, record);
    }

    public void add(int idx, Record record) {
        if (idx != this.numSlot) {
            RecordBuffer.checkBounds(idx, this.numSlot);
            this.shiftUp(idx);
        } else {
            if (this.numSlot >= this.maxSlot) {
                throw new BufferException(String.format("Out of bounds: idx=%d, ptrs=%d", idx, this.maxSlot));
            }
            ++this.numSlot;
        }
        this._set(idx, record);
    }

    public void set(int idx, Record record) {
        if (idx == this.numSlot) {
            this.add(idx, record);
            return;
        }
        RecordBuffer.checkBounds(idx, this.numSlot);
        this._set(idx, record);
    }

    public Record _get(int idx) {
        return this.factory.buildFrom(this.bb, idx);
    }

    void _set(int idx, Record rec) {
        this.factory.insertInto(rec, this.bb, idx);
    }

    int find1(byte[] data) {
        for (int i = 0; i < this.numSlot; ++i) {
            int x = this.compare(i, data);
            if (x == 0) {
                return i;
            }
            if (x <= 0) continue;
            return Lib.encodeIndex(i);
        }
        return Lib.encodeIndex(this.numSlot);
    }

    public int find(Record k) {
        return this.find(k, 0, this.numSlot);
    }

    public Iterator<Record> iterator() {
        return new RecordBufferIterator(this);
    }

    public Iterator<Record> iterator(Record min, Record max) {
        return new RecordBufferIterator(this, min, max);
    }

    public Record findGet(Record k) {
        int x = this.find(k);
        if (x >= 0) {
            return this.get(x);
        }
        return null;
    }

    public boolean removeByKey(Record k) {
        int x = this.find(k);
        if (x < 0) {
            return false;
        }
        super.remove(x);
        return true;
    }

    public int find(Record rec, int fromIndex, int toIndex) {
        int low = fromIndex;
        int high = toIndex - 1;
        byte[] key = rec.getKey();
        while (low <= high) {
            int mid = low + high >>> 1;
            int x = this.compare(mid, key);
            if (x < 0) {
                low = mid + 1;
                continue;
            }
            if (x > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return Lib.encodeIndex(low);
    }

    private int compare(int idx, byte[] value) {
        idx *= this.slotLen;
        for (int i = 0; i < value.length; ++i) {
            byte b2;
            byte b1 = this.bb.get(idx + i);
            if (b1 == (b2 = value[i])) continue;
            return (b1 & 0xFF) - (b2 & 0xFF);
        }
        return 0;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(40000);
        str.append(String.format("Len=%d Max=%d: ", this.numSlot, this.bb.limit() / this.slotLen));
        for (int i = 0; i < this.numSlot; ++i) {
            if (i != 0) {
                str.append(" ");
            }
            Record r = this._get(i);
            str.append(r.toString());
        }
        String s = str.toString();
        return s;
    }

    private static void checkBounds(int idx, int len) {
        if (idx < 0 || idx >= len) {
            throw new IllegalArgumentException(String.format("Out of bounds: idx=%d, size=%d", idx, len));
        }
    }

    public RecordBuffer duplicate() {
        RecordBuffer n = new RecordBuffer(this.factory, this.maxSlot);
        this.copy(0, n, 0, this.maxSlot);
        n.numSlot = this.numSlot;
        return n;
    }
}

