/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Named;
import com.hp.hpl.jena.sparql.util.Printable;
import com.hp.hpl.jena.tdb.TDBException;

public enum BlockType implements Printable,
Named
{
    BTREE_BRANCH{

        public String getName() {
            return "BTreeBranch";
        }

        @Override
        public int id() {
            return 5;
        }
    }
    ,
    BPTREE_BRANCH{

        public String getName() {
            return "BPlusTreeBranch";
        }

        @Override
        public int id() {
            return 6;
        }
    }
    ,
    BPTREE_LEAF{

        public String getName() {
            return "BPlusTreeBranch";
        }

        @Override
        public int id() {
            return 7;
        }
    }
    ,
    DICTIONARY{

        public String getName() {
            return "DICTIONARY";
        }

        @Override
        public int id() {
            return 10;
        }
    }
    ,
    RECORD_BLOCK{

        public String getName() {
            return "RecordBlock";
        }

        @Override
        public int id() {
            return 99;
        }
    };


    public void output(IndentedWriter out) {
        out.print((Object)this.getName());
    }

    public abstract int id();

    public String toString() {
        return this.getName();
    }

    public static BlockType extract(int x) {
        if (x == BTREE_BRANCH.id()) {
            return BTREE_BRANCH;
        }
        if (x == BPTREE_BRANCH.id()) {
            return BPTREE_BRANCH;
        }
        if (x == BPTREE_LEAF.id()) {
            return BPTREE_LEAF;
        }
        if (x == RECORD_BLOCK.id()) {
            return RECORD_BLOCK;
        }
        throw new TDBException("No known block type for " + x);
    }
}

