/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.tdb.base.block.BlockException;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFile;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlockMgrMapped
extends BlockMgrFile {
    private static Logger log = LoggerFactory.getLogger(BlockMgrMapped.class);
    private final int GrowthFactor = 2;
    private final int SegmentSize = 0x800000;
    private final int blocksPerSegment;
    private int initialNumSegements = 1;
    private MappedByteBuffer[] segments = new MappedByteBuffer[this.initialNumSegements];
    private int segmentDirtyCount = 0;
    private boolean[] segmentDirty = new boolean[this.initialNumSegements];

    BlockMgrMapped(String filename, int blockSize) {
        super(filename, blockSize);
        this.blocksPerSegment = 0x800000 / blockSize;
        if (0x800000 % blockSize != 0) {
            this.getLog().warn(String.format("%s: Segement size(%d) not a multiple of blocksize (%d)", filename, 0x800000, blockSize));
        }
        for (int i = 0; i < this.initialNumSegements; ++i) {
            this.segmentDirty[i] = false;
        }
        this.segmentDirtyCount = 0;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(String.format("Segment:%d  BlockSize=%d  blocksPerSegment=%d", 0x800000, blockSize, this.blocksPerSegment));
        }
    }

    @Override
    public ByteBuffer allocateBuffer(int id) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(String.format("allocateBuffer(%d)", id));
        }
        ByteBuffer bb = this.getSilent(id);
        bb.position(0);
        return bb;
    }

    @Override
    public ByteBuffer get(int id) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(String.format("get(%d)", id));
        }
        return this.getSilent(id);
    }

    @Override
    public ByteBuffer getSilent(int id) {
        this.check(id);
        int seg = this.segment(id);
        int segOff = this.byteOffset(id);
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace(String.format("%d => [%d, %d]", id, seg, segOff));
        }
        BlockMgrMapped blockMgrMapped = this;
        synchronized (blockMgrMapped) {
            try {
                MappedByteBuffer segBuffer = this.allocSegment(seg);
                ((ByteBuffer)segBuffer).position(segOff);
                ((ByteBuffer)segBuffer).limit(segOff + this.blockSize);
                ByteBuffer dst = ((ByteBuffer)segBuffer).slice();
                ((ByteBuffer)segBuffer).limit(segBuffer.capacity());
                this.numFileBlocks = Math.max(this.numFileBlocks, (long)(id + 1));
                return dst;
            }
            catch (IllegalArgumentException ex) {
                log.error("Id: " + id);
                log.error("Seg=" + seg);
                log.error("Segoff=" + segOff);
                log.error(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }

    private final int segment(int id) {
        return id / this.blocksPerSegment;
    }

    private final int byteOffset(int id) {
        return id % this.blocksPerSegment * this.blockSize;
    }

    private final long fileLocation(long segmentNumber) {
        return segmentNumber * 0x800000L;
    }

    private MappedByteBuffer allocSegment(int seg) {
        if (seg < 0) {
            this.getLog().error("Segment negative: " + seg);
            throw new BlockException("Negative segment: " + seg);
        }
        while (seg >= this.segments.length) {
            MappedByteBuffer[] segments2 = new MappedByteBuffer[2 * this.segments.length];
            System.arraycopy(this.segments, 0, segments2, 0, this.segments.length);
            boolean[] segmentDirty2 = new boolean[2 * this.segmentDirty.length];
            System.arraycopy(this.segmentDirty, 0, segmentDirty2, 0, this.segmentDirty.length);
            this.segmentDirty = segmentDirty2;
            this.segments = segments2;
        }
        long offset = this.fileLocation(seg);
        if (offset < 0L) {
            this.getLog().error("Segment offset gone negative: " + seg);
            throw new BlockException("Negative segment offset: " + seg);
        }
        MappedByteBuffer segBuffer = this.segments[seg];
        if (segBuffer == null) {
            try {
                segBuffer = this.channel.map(FileChannel.MapMode.READ_WRITE, offset, 0x800000L);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug(String.format("Segment: %d", seg));
                }
                this.segments[seg] = segBuffer;
            }
            catch (IOException ex) {
                if (ex.getCause() instanceof OutOfMemoryError) {
                    throw new BlockException("BlockMgrMapped.segmentAllocate: Segment = " + seg + " : Offset = " + offset);
                }
                throw new BlockException("BlockMgrMapped.segmentAllocate: Segment = " + seg, ex);
            }
        }
        return segBuffer;
    }

    private synchronized void flushDirtySegments() {
        for (int i = 0; i < this.segments.length; ++i) {
            if (this.segments[i] == null || !this.segmentDirty[i]) continue;
            this.segments[i].force();
            this.segmentDirty[i] = false;
            --this.segmentDirtyCount;
        }
    }

    @Override
    public void put(int id, ByteBuffer block) {
        this.check(id, block);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(String.format("put(%d)", id));
        }
        this.segmentDirty[this.segment((int)id)] = true;
        this.putNotification(id, block);
    }

    @Override
    public void freeBlock(int id) {
        this.check(id);
        int seg = id / this.blocksPerSegment;
        this.segmentDirty[seg] = false;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(String.format("freeBlock(%d)", id));
        }
    }

    @Override
    public void sync(boolean force) {
        if (force) {
            this.force();
        }
    }

    @Override
    protected void force() {
        this.flushDirtySegments();
        super.force();
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

