/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.tdb.base.block.BlockException;
import com.hp.hpl.jena.tdb.base.block.BlockMgrFile;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockMgrDirect
extends BlockMgrFile {
    private static Logger log = LoggerFactory.getLogger(BlockMgrDirect.class);

    BlockMgrDirect(String filename, int blockSize) {
        super(filename, blockSize);
    }

    @Override
    public ByteBuffer allocateBuffer(int id) {
        return ByteBuffer.allocate(this.blockSize);
    }

    @Override
    public ByteBuffer get(int id) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("get(%d)", id));
        }
        return this.getSilent(id);
    }

    @Override
    public ByteBuffer getSilent(int id) {
        this.check(id);
        try {
            ByteBuffer dst = this.allocateBuffer(id);
            int len = this.channel.read(dst, this.filePosition(id));
            if (len != this.blockSize) {
                throw new BlockException(String.format("get: short read (%d, not %d)", len, this.blockSize));
            }
            return dst;
        }
        catch (IOException ex) {
            throw new BlockException("BlockMgrDirect.get", ex);
        }
    }

    @Override
    public void put(int id, ByteBuffer block) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("put(%d)", id));
        }
        this.check(id, block);
        block.position(0);
        block.limit(block.capacity());
        try {
            int len = this.channel.write(block, this.filePosition(id));
            if (len != this.blockSize) {
                throw new BlockException(String.format("put: short write (%d, not %d)", len, this.blockSize));
            }
        }
        catch (IOException ex) {
            throw new BlockException("BlockMgrDirect.put", ex);
        }
        this.putNotification(id, block);
    }

    private final long filePosition(int id) {
        return (long)id * (long)this.blockSize;
    }

    @Override
    public void freeBlock(int id) {
        this.check(id);
        if (log.isDebugEnabled()) {
            log.debug(String.format("release(%d)", id));
        }
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    public void sync(boolean force) {
        if (force) {
            this.force();
        }
    }
}

