/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrWrapper;
import java.nio.ByteBuffer;
import java.util.Iterator;
import lib.ActionKeyValue;
import lib.Cache;
import lib.CacheFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockMgrCache
extends BlockMgrWrapper {
    private static Logger log = LoggerFactory.getLogger(BlockMgrCache.class);
    Cache<Integer, ByteBuffer> readCache = null;
    Cache<Integer, ByteBuffer> writeCache = null;
    public static boolean globalLogging = false;
    private boolean logging = false;
    private String indexName;
    long cacheHits = 0L;
    long cacheMisses = 0L;
    long cacheWriteHits = 0L;

    public BlockMgrCache(String indexName, int readSlots, int writeSlots, BlockMgr blockMgr) {
        super(blockMgr);
        this.indexName = String.format("%-12s", indexName);
        this.readCache = CacheFactory.createCache(readSlots);
        if (writeSlots > 0) {
            this.writeCache = CacheFactory.createCache(writeSlots);
            this.writeCache.setDropHandler(new ActionKeyValue<Integer, ByteBuffer>(){

                @Override
                public void apply(Integer id, ByteBuffer bb) {
                    BlockMgrCache.this.log("Cache spill: write block: %d", new Object[]{id});
                    BlockMgrCache.this.expelEntry(id);
                }
            });
        }
    }

    private void expelEntry(Integer id) {
        ByteBuffer bb = this.writeCache.getObject(id);
        if (bb == null) {
            return;
        }
        this.log("Drop (write cache): %d", id);
        this.blockMgr.put(id, bb);
        this.writeCache.removeObject(id);
    }

    @Override
    public ByteBuffer get(int id) {
        return this.fetchEntry(id, false);
    }

    @Override
    public ByteBuffer getSilent(int id) {
        return this.fetchEntry(id, true);
    }

    private ByteBuffer fetchEntry(int id, boolean silent) {
        ByteBuffer bb = this.readCache.getObject(id);
        if (bb != null) {
            ++this.cacheHits;
            this.log("Hit(r) : %d", id);
            return bb;
        }
        if (this.writeCache != null && (bb = this.writeCache.getObject(id)) != null) {
            ++this.cacheWriteHits;
            this.log("Hit(w) : %d", id);
            return bb;
        }
        ++this.cacheMisses;
        this.log("Miss  : %d", id);
        bb = silent ? this.blockMgr.getSilent(id) : this.blockMgr.get(id);
        this.readCache.putObject(id, bb);
        return bb;
    }

    @Override
    public void put(int id, ByteBuffer block) {
        this.log("Put   : %d", id);
        if (this.writeCache != null) {
            this.writeCache.putObject(id, block);
        } else {
            this.blockMgr.put(id, block);
        }
        this.readCache.putObject(id, block);
    }

    @Override
    public void freeBlock(int id) {
        this.log("Free  : %d", id);
        this.readCache.removeObject(id);
        if (this.writeCache != null) {
            this.writeCache.removeObject(id);
        }
        this.blockMgr.freeBlock(id);
    }

    @Override
    public void sync(boolean force) {
        String x = "";
        if (this.indexName != null) {
            x = this.indexName + " : ";
        }
        this.log("%sH=%d, M=%d, W=%d", x, this.cacheHits, this.cacheMisses, this.cacheWriteHits);
        if (this.writeCache != null) {
            this.log("sync (%d blocks)", this.writeCache.size());
        } else {
            this.log("sync", new Object[0]);
        }
        this.syncFlush(force);
    }

    private void log(String fmt, Object ... args) {
        if (!this.logging && !globalLogging) {
            return;
        }
        String msg = String.format(fmt, args);
        if (this.indexName != null) {
            msg = this.indexName + " : " + msg;
        }
        log.debug(msg);
    }

    @Override
    public void close() {
        this.log("close (" + this.writeCache.size() + " blocks)", new Object[0]);
        this.syncFlush(true);
        this.blockMgr.close();
    }

    private void syncFlush(boolean all) {
        if (this.writeCache != null) {
            this.log("Flush (write cache)", new Object[0]);
            long N = this.writeCache.size();
            Integer[] ids = new Integer[(int)N];
            Iterator<Integer> iter = this.writeCache.keys();
            int i = 0;
            while (iter.hasNext()) {
                ids[i] = iter.next();
                ++i;
            }
            long limit = 3L * N / 4L;
            if (all) {
                limit = N;
            }
            for (int i2 = 0; i2 < (int)limit; ++i2) {
                Integer id = ids[i2];
                this.expelEntry(id);
            }
        }
    }
}

