/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockType;
import com.hp.hpl.jena.tdb.base.page.PageBase;
import java.nio.ByteBuffer;

public class BlockConverter<T extends PageBase> {
    private BlockMgr blockMgr;
    private Converter<T> pageFactory;

    protected BlockConverter(Converter<T> pageFactory, BlockMgr blockMgr) {
        this.pageFactory = pageFactory;
        this.blockMgr = blockMgr;
    }

    protected void setConverter(Converter<T> pageFactory) {
        this.pageFactory = pageFactory;
    }

    public BlockMgr getBlockMgr() {
        return this.blockMgr;
    }

    public int allocateId() {
        return this.blockMgr.allocateId();
    }

    public T create(int id, BlockType bType) {
        ByteBuffer bb = this.blockMgr.allocateBuffer(id);
        PageBase newThing = (PageBase)this.pageFactory.createFromByteBuffer(bb, bType);
        newThing.setId(id);
        return (T)newThing;
    }

    public T get(int id) {
        ByteBuffer bb = this.blockMgr.get(id);
        PageBase newThing = (PageBase)this.pageFactory.fromByteBuffer(bb);
        newThing.setId(id);
        return (T)newThing;
    }

    public T getSilent(int id) {
        ByteBuffer bb = this.blockMgr.getSilent(id);
        PageBase newThing = (PageBase)this.pageFactory.fromByteBuffer(bb);
        newThing.setId(id);
        return (T)newThing;
    }

    public void put(int id, T page) {
        ByteBuffer bb = this.pageFactory.toByteBuffer(page);
        this.blockMgr.put(id, bb);
    }

    public void put(T page) {
        this.put(((PageBase)page).getId(), page);
    }

    public void release(int id) {
        this.blockMgr.freeBlock(id);
    }

    public boolean valid(int id) {
        return this.blockMgr.valid(id);
    }

    public void dump() {
        int idx = 0;
        while (this.valid(idx)) {
            T page = this.get(idx);
            System.out.println(page);
            ++idx;
        }
    }

    public void startUpdate() {
        this.blockMgr.startUpdate();
    }

    public void finishUpdate() {
        this.blockMgr.finishUpdate();
    }

    public void startRead() {
        this.blockMgr.startRead();
    }

    public void finishRead() {
        this.blockMgr.finishRead();
    }

    public static interface Converter<T> {
        public T fromByteBuffer(ByteBuffer var1);

        public ByteBuffer toByteBuffer(T var1);

        public T createFromByteBuffer(ByteBuffer var1, BlockType var2);
    }
}

