/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.assembler;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.exceptions.AssemblerException;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.graph.GraphUtils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.TDBFactory;
import com.hp.hpl.jena.tdb.assembler.IndexAssembler;
import com.hp.hpl.jena.tdb.assembler.VocabTDB;
import com.hp.hpl.jena.tdb.base.file.Location;

public class TDBGraphAssembler
extends AssemblerBase
implements Assembler {
    static IndexAssembler indexAssembler = null;

    public Model open(Assembler a, Resource root, Mode mode) {
        TDB.init();
        if (!GraphUtils.exactlyOneProperty((Resource)root, (Property)VocabTDB.pLocation)) {
            throw new AssemblerException(root, "No location given");
        }
        String dir = GraphUtils.getStringValue((Resource)root, (Property)VocabTDB.pLocation);
        Location loc = new Location(dir);
        if (!root.hasProperty(VocabTDB.pIndex)) {
            return TDBFactory.createModel(loc);
        }
        StmtIterator sIter = root.listProperties(VocabTDB.pIndex);
        while (sIter.hasNext()) {
            RDFNode obj = sIter.nextStatement().getObject();
            if (obj.isLiteral()) {
                String desc = ((Literal)obj).getString();
                System.out.printf("Index: %s\n", desc);
                System.out.flush();
                continue;
            }
            throw new TDBException("Wrong format for tdb:index: should be a string: found: " + FmtUtils.stringForRDFNode((RDFNode)obj));
        }
        System.out.flush();
        throw new TDBException("Custom indexes turned off");
    }
}

