/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.tdb.lib.NodeLib;
import junit.TestBase;
import org.junit.Test;

public class TestNodeLib
extends TestBase {
    @Test
    public void hash1() {
        Node x1 = SSE.parseNode((String)"<http://example/x>");
        Node x2 = SSE.parseNode((String)"<http://example/x>");
        TestNodeLib.assertEquals((Object)NodeLib.hash(x1), (Object)NodeLib.hash(x2));
    }

    @Test
    public void hash2() {
        Node x1 = SSE.parseNode((String)"<http://example/x1>");
        Node x2 = SSE.parseNode((String)"<http://example/x2>");
        TestNodeLib.assertNotEquals(NodeLib.hash(x1), NodeLib.hash(x2));
    }

    @Test
    public void hash3() {
        Node x1 = SSE.parseNode((String)"<lex>");
        Node x2 = SSE.parseNode((String)"'lex'");
        Node x3 = SSE.parseNode((String)"_:lex");
        TestNodeLib.assertNotEquals(NodeLib.hash(x1), NodeLib.hash(x2));
        TestNodeLib.assertNotEquals(NodeLib.hash(x2), NodeLib.hash(x3));
        TestNodeLib.assertNotEquals(NodeLib.hash(x3), NodeLib.hash(x1));
    }

    @Test
    public void hash4() {
        Node x1 = SSE.parseNode((String)"123");
        Node x2 = SSE.parseNode((String)"'123'");
        TestNodeLib.assertNotEquals(NodeLib.hash(x1), NodeLib.hash(x2));
    }

    @Test
    public void hash5() {
        Node x1 = SSE.parseNode((String)"123");
        Node x2 = SSE.parseNode((String)"123.0");
        Node x3 = SSE.parseNode((String)"123e0");
        TestNodeLib.assertNotEquals(NodeLib.hash(x1), NodeLib.hash(x2));
        TestNodeLib.assertNotEquals(NodeLib.hash(x2), NodeLib.hash(x3));
        TestNodeLib.assertNotEquals(NodeLib.hash(x3), NodeLib.hash(x1));
    }
}

