/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetImpl;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.tdb.TDB;
import com.hp.hpl.jena.tdb.assembler.VocabTDB;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.pgraph.PGraphFactory;
import com.hp.hpl.jena.tdb.store.FactoryGraphTDB;
import lib.NotImplemented;

public class TDBFactory {
    static ImplFactory factory = null;
    public static final ImplFactory pgraphFactory = new ImplFactory(){

        @Override
        public Graph createGraph() {
            return PGraphFactory.createMem();
        }

        @Override
        public Graph createGraph(Location loc) {
            return PGraphFactory.create(loc);
        }

        @Override
        public DatasetGraph createDatasetGraph(Location location) {
            throw new NotImplemented("Dataset/PGraph");
        }

        @Override
        public DatasetGraph createDatasetGraph() {
            throw new NotImplemented("Dataset/PGraph");
        }
    };
    public static final ImplFactory stdFactory = new ImplFactory(){

        @Override
        public Graph createGraph() {
            return FactoryGraphTDB.createGraphMem();
        }

        @Override
        public Graph createGraph(Location loc) {
            return FactoryGraphTDB.createGraph(loc);
        }

        @Override
        public DatasetGraph createDatasetGraph(Location location) {
            return FactoryGraphTDB.createDatasetGraph(location);
        }

        @Override
        public DatasetGraph createDatasetGraph() {
            return FactoryGraphTDB.createDatasetGraphMem();
        }
    };

    public static Model assembleModel(String assemblerFile) {
        return (Model)AssemblerUtils.build((String)assemblerFile, (Resource)VocabTDB.tGraphTDB);
    }

    public static Graph assembleGraph(String assemblerFile) {
        Model m = TDBFactory.assembleModel(assemblerFile);
        Graph g = m.getGraph();
        return g;
    }

    public static Dataset assembleDataset(String assemblerFile) {
        return (Dataset)AssemblerUtils.build((String)assemblerFile, (Resource)VocabTDB.tDatasetTDB);
    }

    public static Model createModel(Location loc) {
        return ModelFactory.createModelForGraph((Graph)TDBFactory.createGraph(loc));
    }

    public static Model createModel(String dir) {
        return ModelFactory.createModelForGraph((Graph)TDBFactory.createGraph(dir));
    }

    public static Graph createGraph(Location loc) {
        return TDBFactory._createGraph(loc);
    }

    public static Graph createGraph(String dir) {
        Location loc = new Location(dir);
        return TDBFactory.createGraph(loc);
    }

    public static Model createModel() {
        return ModelFactory.createModelForGraph((Graph)TDBFactory.createGraph());
    }

    public static Graph createGraph() {
        return TDBFactory._createGraph();
    }

    public static Dataset createDataset(String dir) {
        return TDBFactory.createDataset(new Location(dir));
    }

    public static Dataset createDataset(Location location) {
        return new DatasetImpl(factory.createDatasetGraph(location));
    }

    public static Dataset createDataset() {
        return new DatasetImpl(factory.createDatasetGraph());
    }

    private static Graph _createGraph() {
        return factory.createGraph();
    }

    private static Graph _createGraph(Location loc) {
        return factory.createGraph(loc);
    }

    public static void setImplFactory(ImplFactory f) {
        factory = f;
    }

    static {
        TDB.init();
        TDBFactory.setImplFactory(stdFactory);
    }

    public static interface ImplFactory {
        public Graph createGraph();

        public Graph createGraph(Location var1);

        public DatasetGraph createDatasetGraph();

        public DatasetGraph createDatasetGraph(Location var1);
    }
}

