/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.impl.RDFReaderFImpl;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.assembler.AssemblerUtils;
import com.hp.hpl.jena.sparql.engine.main.StageGenBasicPattern;
import com.hp.hpl.jena.sparql.engine.main.StageGenerator;
import com.hp.hpl.jena.sparql.engine.optimizer.StageGenOptimizedBasicPattern;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Symbol;
import com.hp.hpl.jena.tdb.assembler.VocabTDB;
import com.hp.hpl.jena.tdb.base.reader.NTriplesReader2;
import com.hp.hpl.jena.tdb.lib.Sync;
import com.hp.hpl.jena.tdb.solver.OpExecutorTDB;
import com.hp.hpl.jena.tdb.solver.QueryEngineTDB;
import com.hp.hpl.jena.tdb.solver.StageGeneratorDirectTDB;
import com.hp.hpl.jena.tdb.solver.StageGeneratorGeneric;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.sys.Metadata;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDB {
    private static final Logger log = LoggerFactory.getLogger(TDB.class);
    public static final Logger logInfo = LoggerFactory.getLogger((String)"com.hp.hpl.jena.tdb.info");
    public static final Logger logExec = LoggerFactory.getLogger((String)"com.hp.hpl.jena.tdb.exec");
    public static final String namespace = "http://jena.hpl.hp.com/2008/tdb#";
    public static final Symbol symUnionDefaultGraph = SystemTDB.allocSymbol("unionDefaultGraph");
    public static final Symbol symLogExec = SystemTDB.allocSymbol("logExec");
    private static boolean initialized;
    public static final String PATH = "com.hp.hpl.jena.tdb";
    public static final String NAME = "TDB";
    public static final String VERSION;
    public static final String BUILD_DATE;

    public static void setExecutionLogging(boolean state) {
        TDB.getContext().set(symLogExec, state);
        if (!logExec.isInfoEnabled()) {
            log.warn("Attempt to enable execution logging but the logger is not logging at level info");
        }
    }

    public static Context getContext() {
        return ARQ.getContext();
    }

    public static void init() {
    }

    public static void sync(Model model) {
        TDB.sync(model.getGraph());
    }

    public static void sync(Graph graph) {
        TDB.sync(graph, true);
    }

    public static void sync(Dataset dataset) {
        DatasetGraph ds = dataset.asDatasetGraph();
        TDB.sync(ds);
    }

    public static void sync(DatasetGraph dataset) {
        if (dataset instanceof DatasetGraphTDB) {
            TDB.sync(dataset, true);
        } else {
            Iterator iter = dataset.listGraphNodes();
            while (iter.hasNext()) {
                Node n = (Node)iter.next();
                Graph g = dataset.getGraph(n);
                TDB.sync(g);
            }
        }
    }

    private static void sync(Object object, boolean force) {
        if (object instanceof Sync) {
            ((Sync)object).sync(force);
        }
    }

    private static synchronized void initWorker() {
        if (initialized) {
            return;
        }
        initialized = true;
        AssemblerUtils.init();
        VocabTDB.init();
        QueryEngineTDB.register();
        TDB.getContext().set(ARQ.filterPlacement, false);
        TDB.wireIntoExecution();
        String bulkLoaderClass = NTriplesReader2.class.getName();
        RDFReaderFImpl.setBaseReaderClassName((String)"N-TRIPLES", (String)bulkLoaderClass);
        RDFReaderFImpl.setBaseReaderClassName((String)"N-TRIPLE", (String)bulkLoaderClass);
        if (log.isDebugEnabled()) {
            log.debug("\n" + ARQ.getContext());
        }
    }

    private static void wireIntoExecution() {
        StageGenerator orig = (StageGenerator)ARQ.getContext().get(ARQ.stageGenerator);
        if (orig instanceof StageGenBasicPattern || orig instanceof StageGenOptimizedBasicPattern) {
            orig = new StageGeneratorGeneric();
        }
        StageGeneratorDirectTDB stageGenerator = new StageGeneratorDirectTDB(orig);
        ARQ.getContext().set(ARQ.stageGenerator, (Object)stageGenerator);
        ARQ.getContext().set(ARQConstants.sysOpExecutorFactory, (Object)OpExecutorTDB.altFactory);
    }

    static {
        TDB.initWorker();
        initialized = false;
        VERSION = Metadata.get("com.hp.hpl.jena.tdb.version", "unknown");
        BUILD_DATE = Metadata.get("com.hp.hpl.jena.tdb.build.datetime", "unset");
    }
}

