/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.writers;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.writers.WriterLib;
import com.hp.hpl.jena.sparql.sse.writers.WriterNode;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Iterator;
import java.util.ListIterator;

public class WriterGraph {
    public static final int NL = 1;
    public static final int NoNL = -1;
    public static final int NoSP = -2;

    public static void output(IndentedWriter out, Graph graph, SerializationContext naming) {
        WriterGraph.output(out, graph, null, naming);
    }

    public static void output(IndentedWriter out, Graph graph, String uri, SerializationContext naming) {
        WriterGraph.writeGraph(out, graph, uri, naming);
    }

    public static void output(IndentedWriter out, DatasetGraph dataset, SerializationContext naming) {
        WriterGraph.writeDataset(out, dataset, naming);
    }

    public static void output(IndentedWriter out, BasicPattern pattern, SerializationContext sCxt) {
        ListIterator iter = pattern.iterator();
        while (iter.hasNext()) {
            Triple triple = (Triple)iter.next();
            WriterNode.output(out, triple, sCxt);
            out.println();
        }
    }

    private static void writeDataset(IndentedWriter out, DatasetGraph ds, SerializationContext naming) {
        WriterLib.start(out, "dataset", 1);
        WriterGraph.writeGraph(out, ds.getDefaultGraph(), naming);
        out.ensureStartOfLine();
        Iterator iter = ds.listGraphNodes();
        while (iter.hasNext()) {
            out.ensureStartOfLine();
            Node node = (Node)iter.next();
            Graph g = ds.getGraph(node);
            WriterGraph.writeGraph(out, g, node, naming);
        }
        WriterLib.finish(out, "dataset");
        out.ensureStartOfLine();
    }

    private static void writeGraph(IndentedWriter out, Graph g, SerializationContext naming) {
        WriterGraph._writeGraph(out, g, null, naming);
    }

    private static void writeGraph(IndentedWriter out, Graph g, String uri, SerializationContext naming) {
        String x = null;
        if (uri != null) {
            x = FmtUtils.stringForURI(uri);
        }
        WriterGraph._writeGraph(out, g, x, naming);
    }

    private static void writeGraph(IndentedWriter out, Graph g, Node node, SerializationContext naming) {
        String x = null;
        if (node != null) {
            x = FmtUtils.stringForNode(node);
        }
        WriterGraph._writeGraph(out, g, x, naming);
    }

    private static void _writeGraph(IndentedWriter out, Graph g, String label, SerializationContext naming) {
        ExtendedIterator iter;
        WriterLib.start(out, "graph", -2);
        if (label != null) {
            out.print(" ");
            out.print(label);
        }
        if (!(iter = g.find(Node.ANY, Node.ANY, Node.ANY)).hasNext()) {
            WriterLib.finish(out, "graph");
            return;
        }
        out.println();
        out.incIndent();
        boolean first = true;
        while (iter.hasNext()) {
            if (!first) {
                out.println();
            }
            first = false;
            Triple triple = (Triple)iter.next();
            WriterNode.output(out, triple, naming);
        }
        out.decIndent();
        if (!first) {
            out.println();
        }
        WriterLib.finish(out, "graph");
    }
}

