/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpWalker;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.main.StageBuilder;
import com.hp.hpl.jena.sparql.engine.optimizer.ExplainFormatter;
import com.hp.hpl.jena.sparql.engine.optimizer.StageGenOptimizedBasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.core.BasicPatternGraph;
import com.hp.hpl.jena.sparql.engine.optimizer.core.BasicPatternOptimizer;
import com.hp.hpl.jena.sparql.engine.optimizer.core.BasicPatternVisitor;
import com.hp.hpl.jena.sparql.engine.optimizer.core.ConnectedGraph;
import com.hp.hpl.jena.sparql.engine.optimizer.core.GraphEdge;
import com.hp.hpl.jena.sparql.engine.optimizer.core.GraphNode;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.Probability;
import com.hp.hpl.jena.sparql.engine.optimizer.probability.ProbabilityFactory;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Config;
import com.hp.hpl.jena.sparql.engine.optimizer.util.Constants;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Optimizer {
    public static final String PATH = "com.hp.hpl.jena.sparql.engine.optimizer";
    public static final String NAME = "ARQ-Optimizer";
    public static final String ACRONYM = "ARQo";
    public static final String WEBSITE = "http://jena.sourceforge.net/ARQ/bgp-optimization.html";
    public static final String VERSION = "0.2";

    public static void enable() {
        Optimizer.enable(ARQ.getContext(), new Config());
    }

    public static void enable(Config config) {
        Optimizer.enable(ARQ.getContext(), config);
    }

    public static void enable(Model data, Model index) {
        Optimizer.enable(ARQ.getContext(), data, index, null);
    }

    public static void enable(Model data, Model index, Config config) {
        Optimizer.enable(ARQ.getContext(), data, index, config);
    }

    public static void enable(Context context, Model data, Model index, Config config) {
        Probability probability = ProbabilityFactory.loadDefaultModel(data, index, config);
        context.set(Constants.PF, probability);
        Optimizer.enable(context, config);
    }

    public static void enable(Context context, Config config) {
        context.set(Constants.isEnabled, false);
        context.set(ARQ.stageGenerator, new StageGenOptimizedBasicPattern(StageBuilder.getGenerator(), config));
    }

    public static void disable(Context context) {
        context.set(Constants.isEnabled, false);
        context.set(ARQ.stageGenerator, StageBuilder.standardGenerator());
    }

    public static void disable() {
        Optimizer.disable(ARQ.getContext());
    }

    public static Model index(Model data) {
        return Optimizer.index(data, null);
    }

    public static Model index(Model data, Config config) {
        return ProbabilityFactory.createIndex(data, config);
    }

    public static Model index(Graph data, Config config) {
        return ProbabilityFactory.createIndex(data, config);
    }

    public static String explain(Query query) {
        return Optimizer.explain(ARQ.getContext(), null, query, null);
    }

    public static String explain(Model model, Query query) {
        return Optimizer.explain(ARQ.getContext(), model, query, null);
    }

    public static String explain(Model model, Query query, Config config) {
        return Optimizer.explain(ARQ.getContext(), model, query, config);
    }

    public static String explain(Context context, Model model, Query query, Config config) {
        Graph graph = null;
        String left = "| ";
        String sep = " | ";
        StringBuffer out = new StringBuffer();
        ArrayList<List> rowsTable1 = new ArrayList<List>();
        ArrayList<List> rowsTable2 = new ArrayList<List>();
        PrefixMapping prefix = query.getPrefixMapping();
        BasicPatternVisitor visitor = new BasicPatternVisitor();
        Element el = query.getQueryPattern();
        Op op = Algebra.compile(el);
        op = Algebra.optimize(op, context);
        OpWalker.walk(op, visitor);
        if (model != null) {
            graph = model.getGraph();
        }
        List patterns = visitor.getPatterns();
        Iterator iter = patterns.iterator();
        while (iter.hasNext()) {
            BasicPattern pattern = (BasicPattern)iter.next();
            BasicPatternOptimizer optimizer = new BasicPatternOptimizer(context, graph, pattern, config);
            BasicPatternGraph basicPatternGraph = optimizer.getBasicPatternGraph();
            basicPatternGraph.optimize();
            List components = basicPatternGraph.getComponents();
            Iterator it = components.iterator();
            while (it.hasNext()) {
                ConnectedGraph component = (ConnectedGraph)it.next();
                Set nodes = component.getOptGraphNodeList();
                Set edges = component.getOptGraphEdgeList();
                Iterator i = nodes.iterator();
                while (i.hasNext()) {
                    GraphNode node = (GraphNode)i.next();
                    Triple triple = node.triple();
                    double weight = node.weight();
                    rowsTable1.add(ExplainFormatter.formatCols(prefix, triple, weight));
                }
                if (edges == null || edges.size() <= 0) continue;
                i = edges.iterator();
                while (i.hasNext()) {
                    GraphEdge edge = (GraphEdge)i.next();
                    Triple triple1 = edge.node1().triple();
                    Triple triple2 = edge.node2().triple();
                    double weight = edge.weight();
                    rowsTable2.add(ExplainFormatter.formatCols(prefix, triple1, triple2, weight));
                }
            }
        }
        ExplainFormatter.printTable(out, new String[]{"S", "P", "O", "C"}, rowsTable1, left, sep);
        out.append("\n");
        if (rowsTable2.size() > 0) {
            ExplainFormatter.printTable(out, new String[]{"TP-1", "TP-2", "C"}, rowsTable2, left, sep);
        }
        return out.toString();
    }
}

