/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.algebra.AlgebraGenerator;
import com.hp.hpl.jena.sparql.algebra.AlgebraQuad;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.opt.Optimize;
import com.hp.hpl.jena.sparql.algebra.opt.TransformEqualityFilter;
import com.hp.hpl.jena.sparql.core.DataSourceGraphImpl;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.ref.QueryEngineRef;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.builders.BuilderOp;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.util.Context;

public class Algebra {
    public static boolean AllowOptimization = true;

    private static Transform optimization() {
        return new TransformEqualityFilter();
    }

    public static Op compile(Query query, boolean optimize) {
        Op op = Algebra.compile(query);
        if (optimize) {
            op = Algebra.optimize(op);
        }
        return op;
    }

    public static Op optimize(Op op) {
        return Algebra.optimize(op, null);
    }

    public static Op optimize(Op op, Context context) {
        if (context == null) {
            context = ARQ.getContext();
        }
        if (op == null) {
            return null;
        }
        return Optimize.optimize(op, context);
    }

    public static Op compile(Query query) {
        if (query == null) {
            return null;
        }
        return new AlgebraGenerator().compile(query);
    }

    public static Op compile(Element elt) {
        if (elt == null) {
            return null;
        }
        return new AlgebraGenerator().compile(elt);
    }

    public static Op compileQuad(Query query) {
        if (query == null) {
            return null;
        }
        return Algebra.toQuadForm(Algebra.compile(query));
    }

    public static Op compileQuad(Element elt) {
        if (elt == null) {
            return null;
        }
        return Algebra.toQuadForm(Algebra.compile(elt));
    }

    public static Op compileQuad(Query query, boolean optimize) {
        if (query == null) {
            return null;
        }
        Op op = Algebra.toQuadForm(Algebra.compile(query));
        if (optimize) {
            op = Algebra.optimize(op);
        }
        return op;
    }

    public static Op toQuadForm(Op op) {
        return AlgebraQuad.quadize(op);
    }

    public static Op read(String filename) {
        Item item = SSE.readFile(filename);
        return Algebra.parse(item);
    }

    public static Op parse(String string) {
        Item item = SSE.parse(string);
        return Algebra.parse(item);
    }

    public static Op parse(String string, PrefixMapping pmap) {
        Item item = SSE.parse(string, pmap);
        return Algebra.parse(item);
    }

    public static Op parse(Item item) {
        Op op = BuilderOp.build(item);
        return op;
    }

    public static QueryIterator exec(Op op, Dataset ds) {
        return Algebra.exec(op, ds.asDatasetGraph());
    }

    public static QueryIterator exec(Op op, Model model) {
        return Algebra.exec(op, model.getGraph());
    }

    public static QueryIterator exec(Op op, Graph graph) {
        return Algebra.exec(op, new DataSourceGraphImpl(graph));
    }

    public static QueryIterator exec(Op op, DatasetGraph ds) {
        QueryEngineFactory f = QueryEngineRegistry.findFactory(op, ds, null);
        Plan plan = f.create(op, ds, BindingRoot.create(), null);
        return plan.iterator();
    }

    public static QueryIterator execRef(Op op, Dataset ds) {
        return Algebra.execRef(op, ds.asDatasetGraph());
    }

    public static QueryIterator execRef(Op op, Model model) {
        return Algebra.execRef(op, model.getGraph());
    }

    public static QueryIterator execRef(Op op, Graph graph) {
        return Algebra.execRef(op, new DataSourceGraphImpl(graph));
    }

    public static QueryIterator execRef(Op op, DatasetGraph ds) {
        QueryEngineRef qe = new QueryEngineRef(op, ds, null);
        return qe.getPlan().iterator();
    }
}

