/*
 * Decompiled with CFR 0.152.
 */
package sdb.test;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import sdb.test.Params;
import sdb.test.TestDB;

public class TestStringBase
extends TestDB {
    private Params params;
    private String tempTableName;
    private String testLabel;
    private String baseString;

    public TestStringBase(String testLabel, String baseString, Connection jdbc, Params params, boolean verbose) {
        super(jdbc, verbose);
        this.params = params;
        this.tempTableName = params.get("TempTable");
        this.testLabel = testLabel;
        this.baseString = baseString;
    }

    @Before
    public void before() {
        this.execNoFail("DROP TABLE %s", this.tempTableName);
    }

    @After
    public void after() {
    }

    @Test
    public void text() throws Exception {
        this.runTextTest(this.testLabel + "/Text", this.baseString, this.params.get("colVarchar"), this.params.get("typeVarchar"));
    }

    @Test
    public void binary() throws Exception {
        this.runBytesTest(this.testLabel + "/Binary", this.baseString, this.params.get("colBinary"), this.params.get("typeBinary"));
    }

    private void runTextTest(String label, String testString, String colName, String colType) throws Exception {
        if (testString == null) {
            Assert.fail((String)(label + ": Test broken - null input"));
        }
        this.exec("CREATE TABLE %s (%s %s)", this.tempTableName, colName, colType);
        String $str = this.sqlFormat("INSERT INTO %s values (?)", this.tempTableName);
        if (this.verbose) {
            System.out.println($str);
        }
        PreparedStatement ps = this.jdbc.prepareStatement($str);
        ps.setString(1, testString);
        ps.execute();
        ps.close();
        ResultSet rs = this.execQuery("SELECT %s FROM %s ", colName, this.tempTableName);
        rs.next();
        String s = rs.getString(1);
        if (s == null) {
            s = "";
        }
        byte[] b = rs.getBytes(1);
        rs.close();
        if (!testString.equals(s)) {
            for (int i = 0; i < s.length(); ++i) {
                System.out.printf("%x:%x ", testString.charAt(i), (int)s.charAt(i));
            }
            System.out.println();
            String $ = s;
        }
        Assert.assertEquals((String)(this.testLabel + " : " + label), (Object)testString, (Object)s);
    }

    private void runBytesTest(String label, String testString, String colName, String colType) throws Exception {
        if (testString == null) {
            Assert.fail((String)(label + ": Test broken - null input"));
        }
        this.exec("CREATE TABLE %s (%s %s)", this.tempTableName, colName, colType);
        String $str = this.sqlFormat("INSERT INTO %s values (?)", this.tempTableName);
        if (this.verbose) {
            System.out.println($str);
        }
        PreparedStatement ps = this.jdbc.prepareStatement($str);
        ps.setBytes(1, this.stringToBytes(testString));
        ps.execute();
        ps.close();
        ResultSet rs = this.execQuery("SELECT %s FROM %s ", colName, this.tempTableName);
        rs.next();
        byte[] b = rs.getBytes(1);
        String s = "";
        if (b != null) {
            s = this.bytesToString(b);
        }
        rs.close();
        if (!testString.equals(s)) {
            String $ = s;
        }
        Assert.assertEquals((String)(this.testLabel + " : " + label), (Object)testString, (Object)s);
    }

    String bytesToString(byte[] b) {
        if (b == null) {
            Assert.fail((String)(this.testLabel + ": bytesToString(null)"));
        }
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            throw new RuntimeException("No UTF-8 - should not happen");
        }
    }

    byte[] stringToBytes(String s) {
        if (s == null) {
            Assert.fail((String)(this.testLabel + ": stringToByte(null)"));
        }
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            throw new RuntimeException("No UTF-8 - should not happen");
        }
    }
}

