/*
 * Decompiled with CFR 0.152.
 */
package sdb.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class TestDB {
    protected Connection jdbc = null;
    boolean verbose = false;

    public TestDB(Connection jdbc, boolean verbose) {
        this.jdbc = jdbc;
        this.verbose = verbose;
    }

    public void setVerbose(boolean newValue) {
        this.verbose = newValue;
    }

    protected void setConnection(Connection jdbc) {
        this.jdbc = jdbc;
    }

    protected String sqlFormat(String sql, Object ... args) {
        return String.format(sql, args);
    }

    protected void execNoFail(String sql, Object ... args) {
        try {
            this.exec(sql, args);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exec(String sql, Object ... args) throws SQLException {
        sql = this.sqlFormat(sql, args);
        Statement stmt = null;
        try {
            stmt = this.jdbc.createStatement();
            if (this.verbose) {
                System.out.println(sql);
            }
            stmt.execute(sql);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    protected ResultSet execQuery(String sql, Object ... args) throws SQLException {
        sql = this.sqlFormat(sql, args);
        if (this.verbose) {
            System.out.println(sql);
        }
        Statement stmt = this.jdbc.createStatement();
        return stmt.executeQuery(sql);
    }
}

