/*
 * Decompiled with CFR 0.152.
 */
package sdb;

import arq.cmd.TerminationException;
import arq.cmdline.ArgDecl;
import com.hp.hpl.jena.sdb.sql.RS;
import com.hp.hpl.jena.sdb.sql.ResultSetJDBC;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.util.FileManager;
import java.sql.SQLException;
import java.util.List;
import sdb.cmd.CmdArgsDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class sdbsql
extends CmdArgsDB {
    private static ArgDecl argDeclQuery = new ArgDecl(true, "file", "query");
    public static final String usage = "sdbsql --sdb <SPEC> SQLSTRING | --file=FILE";

    public static void main(String ... argv) {
        new sdbsql(argv).mainRun();
    }

    public sdbsql(String ... argv) {
        super(argv);
        this.add(argDeclQuery, "--file=", "SQL command to execute (or positional arguments)");
    }

    protected String getCommandName() {
        return Utils.className((Object)((Object)this));
    }

    protected String getSummary() {
        return this.getCommandName() + " --sdb <SPEC> SQLSTRING | --file=FILE";
    }

    protected void processModulesAndArgs() {
        if (this.contains(argDeclQuery) && this.getNumPositional() > 0) {
            this.cmdError("Can't have both --query and a positional query string", true);
        }
        if (!this.contains(argDeclQuery) && this.getNumPositional() == 0) {
            this.cmdError("Nothing to execute", true);
        }
        if (this.getNumPositional() > 1) {
            this.cmdError("Too many statements to execute", true);
        }
    }

    @Override
    protected void execCmd(List<String> positionalArg) {
        if (this.contains(argDeclQuery)) {
            String x = super.getValue(argDeclQuery);
            String sqlStmt = FileManager.get().readWholeFileAsUTF8(x);
            positionalArg.add(sqlStmt);
        }
        for (String x : positionalArg) {
            this.execOneSQL(x);
        }
        this.getModStore().getConnection().close();
    }

    private void execOneSQL(String sqlStmt) {
        ResultSetJDBC rs;
        long queryTime;
        block10: {
            if (this.isVerbose()) {
                System.out.print(sqlStmt);
                if (!sqlStmt.endsWith("\n")) {
                    System.out.println();
                }
            }
            if (sqlStmt.startsWith("@")) {
                sqlStmt = FileManager.get().readWholeFileAsUTF8(sqlStmt.substring(1));
            }
            this.getModTime().startTimer();
            queryTime = 0L;
            rs = null;
            try {
                rs = this.getModStore().getConnection().exec(sqlStmt);
                queryTime = this.getModTime().readTimer();
                if (rs == null) {
                    System.out.println("Executed with no errors or results");
                    break block10;
                }
                if (this.isQuiet()) {
                    RS.consume(rs.get());
                    break block10;
                }
                RS.printResultSet(rs.get());
            }
            catch (SQLException ex) {
                try {
                    System.err.println("SQL Exception: " + ex.getMessage());
                    throw new TerminationException(9);
                }
                catch (Throwable throwable) {
                    RS.close(rs);
                    throw throwable;
                }
            }
        }
        RS.close(rs);
        long time = this.getModTime().endTimer();
        long fmtTime = time - queryTime;
        if (this.getModTime().timingEnabled()) {
            String totalTimeStr = this.getModTime().timeStr(time);
            String queryTimeStr = this.getModTime().timeStr(queryTime);
            String fmtTimeStr = this.getModTime().timeStr(fmtTime);
            System.out.printf("Query: %s (query %s, formatting %s)\n", totalTimeStr, queryTimeStr, fmtTimeStr);
        }
    }
}

